<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReviewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();
            $table->foreignId('therapist_id');
            $table->foreignId('visitor_id');
            $table->foreignId('session_id');
            $table->text('comment')->nullable();
            $table->integer('rating')->index()->default(0);
            $table->timestamps();
            /*
            $table->foreign('therapist_id')
                ->references('id')
                ->on('therapists')
                ->onDelete('cascade');

            /*$table->foreign('visitor_id')
                ->references('id')
                ->on('visitors')
                ->onDelete('cascade');

            $table->foreign('session_id')
                ->references('id')
                ->on('sessions')
                ->onDelete('cascade');*/
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reviews');
    }
}
