<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTreatmentPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('treatment_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('therapist_id')->nullable();
            $table->foreignId('visitor_id')->constrained()->cascadeOnDelete();
            $table->integer('serial_number')->nullable();
            $table->integer('age')->nullable();
            $table->integer('gender')->nullable();
            $table->integer('problem')->nullable();
            $table->longText('problem_description')->nullable();
            $table->integer('diagnostic')->nullable();
            $table->integer('therap_evaluation')->nullable();
            $table->longText('long_term')->nullable();
            $table->longText('short_term')->nullable();
            $table->integer('therapeutic_intervention')->nullable();
            $table->integer('transfer')->nullable();
            $table->integer('current_status')->nullable();
            $table->timestamp('last_visit')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('treatment_plans');
    }
}
