<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScaleQuestionAnswersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('scale_question_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('scale_id')->nullable();
            $table->foreignId('scales_question_id')->nullable();
            $table->foreignId('scales_choice_id')->nullable();
            $table->string('scales_question_name')->nullable();
            $table->string('scales_choice_name')->nullable();
            $table->integer('point')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scale_question_answers');
    }
}
