<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTherapistsRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('therapists_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('therapists_id')->unsigned();
            $table->string('from')->nullable();
            $table->string('to')->nullable();
            $table->string('column_name')->nullable();
            $table->enum('status', ['pending', 'customer_canceled','admin_canceld','approved']);
            $table->foreign('therapists_id')->references('id')->on('therapists')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('therapists_requests');
    }
}
