<?php
//php artisan db:seed --class=AdminSeeder
use Illuminate\Database\Seeder;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        DB::table('system_profiles')->insert([
            'name' => 'admin',
            'permissions' => '{"profiles":1,"profiles_add":1,"profiles_edit":1,"profiles_delete":1,"profiles_active":1,"profiles_view":1}',
            'active' => 1,
            'active_by' => 1,
            'active_date' => date('Y-m-d H:i:s'),
            'add_by' => 1,
            'add_date' => date('Y-m-d H:i:s'),
        ]);
        DB::table('system_users')->insert([
            'profile_id' => 1,
            'name' => 'admin',
            'email' => 'admin@gmail.com',
            'username' => 'admin',
            'password' => \Illuminate\Support\Facades\Hash::make('12345678'),
            'add_by' => 1,
            'add_date' => date('Y-m-d H:i:s'),
        ]);
        DB::table('system_settings')->insert([
            'user_id' => 1,
            'backend_lang' => 'en',
            'backend_color' => 'default',
            'backend_layout' => 'fluid',
            'backend_header' => 'backend_footer',
            'backend_top_menu_dropdown' => 'light',
            'backend_sidebar_menu_mode' => 'default',
            'backend_sidebar_menu_sub_show' => 'accordion',
            'backend_sidebar_menu_style' => 'default',
            'backend_sidebar_menu_position' => 'left',
            'backend_footer' => 'default',
            'created_at' => date('Y-m-d H:i:s'),
        ]);
    }
}
