<?php

use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        factory(App\User::class, 5)->create(['type'=>'therapists'])->each(function ($user) {
            factory(App\Therapist::class)->create(['user_id'=> $user->id])->each(function ($therapist) {
                factory(App\Therapists_specialties::class)->create(['therapist_id'=>$therapist->id,'speciality_id'=> rand(1,20)]);
                factory(App\Therapists_languages::class)->create(['therapist_id'=>$therapist->id,'language_id'=> rand(1,10)]);
                $sessions = factory(App\Sessions::class, 5)->make();
                $therapist->sessions()->saveMany($sessions);
            });
        });

//        factory(App\User::class, 5)->create(['type'=>'visitors'])->each(function ($user) {
//            factory(App\Visitor::class)->create(['user_id'=> $user->id])->each(function ($visitor) {
//                //factory(App\Sessions::class , 10)->make(['visitor_id'=>$visitor->id]);
//                factory(App\Sessions::class , 5)->create(['visitor_id'=> $visitor->id])->each(function ($session) {
//                    factory(App\Reviews::class)->make(['session_id'=>$session->id,'visitor_id'=> $session->visitor_id]);
//                });
//            });
//        });
    }
}
