(function($) {
    "use strict";

    $(document).ready(function() {


        /*=========================================================================
         ===  MENU SCROLL FIXED
         ========================================================================== */
        var s = $('.lgx-header');
        var pos = s.position();
        if ($(document).scrollTop() > 0) {
            s.addClass('menu-onscroll');
            $('#lgx-header').css({ 'background-color': 'white' });
            $('#logo-image').attr('src', '/assets/img/logo.png').attr('srcset', '/assets/img/logo.png').attr('data-srcset', '/assets/img/logo.png').attr('data-src', '/assets/img/logo.png');
        }
        $(window).on('scroll', function() {
            var windowpos = $(window).scrollTop();
            if (windowpos >= pos.top) {
                s.addClass("menu-onscroll");
                $('#lgx-header').css({ 'background-color': 'white' });
                $('#logo-image').attr('src', "/assets/img/logo.png").attr('srcset', '/assets/img/logo.png').attr('data-srcset', '/assets/img/logo.png').attr('data-src', '/assets/img/logo.png');
            } else {
                // alert(s);
                s.removeClass("menu-onscroll");
                $('#lgx-header').css({ 'background-color': 'transparent' });
                $('.lgx-header .lgx-navbar .lgx-nav .dropdown-menu li a').css({ 'color': '#000000' });
                $('#logo-image').attr('src', "/assets/img/logo-white.png").attr('data-src', "/assets/img/logo-white.png").attr('data-srcset', "/assets/img/logo-white.png").attr('srcset', "/assets/img/logo-white.png");
            }
        });
        /*=========================================================================
         ===  MENU SCROLL FIXED END
         ========================================================================== */



        /*=========================================================================
         ===  // SITE PATH
         ========================================================================== */
        var lgx_path = window.location.protocol + '//' + window.location.host;
        var pathArray = window.location.pathname.split('/');
        for (var i = 1; i < (pathArray.length - 1); i++) {
            lgx_path += '/';
            lgx_path += pathArray[i];
        }

        /*=========================================================================
         ===  // SITE PATH END
         ========================================================================== */






        /*=========================================================================
         ===  SMOOTH SCROLL - REQUIRES JQUERY EASING PLUGIN
         ========================================================================== */

        $('a.lgx-scroll').on('click', function(event) {
            var $anchor = $(this);
            var topTo = $($anchor.attr('href')).offset().top;

            if (window.innerWidth < 768) {
                topTo = (topTo - 90);
            }

            $('html, body').stop().animate({
                scrollTop: topTo
            }, 1500, 'easeInOutExpo');
            event.preventDefault();
            return false;
        });

        /*=========================================================================
         ===  SMOOTH SCROLL END
         ========================================================================== */



        /*=========================================================================
         ===  magnific popup
         ========================================================================== */
        $('#lgx-photo-gallery').magnificPopup({
            delegate: 'a', // child items selector, by clicking on it popup will open
            type: 'image',
            gallery: {
                enabled: true
            },
            image: {
                titleSrc: 'title'
            }
            // other options
        });
        /*=========================================================================
         ===  magnific popup END
         ========================================================================== */



        /*=========================================================================
         ===  HOME PAGE Slider
         ========================================================================== */
        if ($("#lgx-main-slider").length) {
            $("#lgx-main-slider").owlCarousel({
                margin: 0,
                items: 1,
                loop: true,
                autoplay: true,
                dots: false,
                navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
                autoplayTimeout: 5000,
                autoplaySpeed: 500,
                nav: true,
                addClassActive: true
            });
        }
        /*=========================================================================
         ===  HOME PAGE Slider END
         ========================================================================== */




        /*=========================================================================
         ===  Content SLIDER
         ========================================================================== */
        if ($('#lgx-owlcontslider').length) {
            $("#lgx-owlcontslider").owlCarousel({
                margin: 0,
                items: 1,
                loop: true,
                autoplay: true,
                dots: false,
                navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
                autoplayTimeout: 4000,
                autoplaySpeed: 500,
                nav: true,
                addClassActive: true
            });
        }
        /*=========================================================================
         ===  Content SLIDER END
         ========================================================================== */




        /*=========================================================================
         ===  TESTIMONIAL SLIDER
         ========================================================================== */
        if ($('#lgx-owltestimonial').length) {
            $("#lgx-owltestimonial").owlCarousel({
                margin: 0,
                items: 1,
                loop: true,
                autoplay: true,
                dots: false,
                navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
                autoplayTimeout: 5000,
                autoplaySpeed: 500,
                nav: true,
                addClassActive: true
            });
        }
        /*=========================================================================
         ===  TESTIMONIAL SLIDER END
         ========================================================================== */





        /*=========================================================================
         ===  Typed Animation START
         ========================================================================== */
        if ($('#lgx-typed-string').length) {
            $('#lgx-typed-string').typed({
                strings: ["Business Conference 2019", "Digital Conference 2019", "World Conference 2019"],
                // typing speed
                typeSpeed: 10,
                // time before typing starts
                startDelay: 0,
                // backspacing speed
                backSpeed: 0,
                // shuffle the strings
                shuffle: false,
                // time before backspacing
                backDelay: 500,
                // loop
                loop: true,
                // false = infinite
                loopCount: false,
                // show cursor
                showCursor: true,
                // character for cursor
                cursorChar: "|",
                // either html or text
                contentType: 'html'
            });
        }

        /*=========================================================================
         ===  Typed Animation END
         ========================================================================== */





        /*=========================================================================
         ===  Start Contact Form Validation And Ajax Submission
         ========================================================================== */

        var alertInterval; //store the timeout interval ID

        //clear interval for alert message window
        $('#lgx-form-modal').on('hide.bs.modal', function(ev) {
            clearInterval(alertInterval);
        });

        $('.card-body form').validate();
        var $contactForm = $('form.lgx-contactform');
        $contactForm.validate({
            submitHandler: function(form) {
                //console.log(form);
                var $form = $(form);
                //console.log($form.serialize());
                $.ajax({
                    url: lgx_path + '/assets/php/contact.php',
                    type: 'post',
                    data: $form.serialize(),
                    beforeSubmit: function(argument) {
                        //ajax loading icon
                    },
                    success: function(ajaxResponse) {
                        try {
                            var ajaxResponse = $.parseJSON(ajaxResponse);
                            if (ajaxResponse.error) {
                                //for field error
                                //console.log(ajaxResponse.error_field);
                                for (var i = 0; i < ajaxResponse.error_field.length; i++) {
                                    if ($('p#' + ajaxResponse.error_field[i] + '-error').length) {
                                        $('p#' + ajaxResponse.error_field[i] + '-error').text(ajaxResponse.message[ajaxResponse.error_field[i]]);
                                    } else {
                                        $('#' + ajaxResponse.error_field[i]).after('<p id="' + ajaxResponse.error_field[i] + '-error" class="help-block">' + ajaxResponse.message[ajaxResponse.error_field[i]] + '</p>');
                                    }
                                }

                            } else {
                                $('.lgx-form-msg').removeClass('alert-danger').addClass('alert-success').text(ajaxResponse.message);
                                $('#lgx-form-modal').modal('show');
                                alertInterval = setInterval(function() {
                                    $('#lgx-form-modal').modal('hide');
                                }, 5000);
                                $form[0].reset();
                            }
                        } catch (e) {
                            $('.lgx-form-msg').removeClass('alert-success').addClass('alert-danger').text('Sorry, we are failed to contact with you. Please reload the page and try again.');
                            $('#lgx-form-modal').modal('show');
                            alertInterval = setInterval(function() {
                                $('#lgx-form-modal').modal('hide');
                            }, 5000);
                        }
                    },
                    error: function(argument) {
                        $('.lgx-form-msg').removeClass('alert-success').addClass('alert-danger').text('Sorry, we can not communicate with you. Please make sure you are connected with internet.');
                        $('#lgx-form-modal').modal('show');
                        alertInterval = setInterval(function() {
                            $('#lgx-form-modal').modal('hide');
                        }, 5000);
                    },
                    complete: function() {

                    }
                });

                return false;
            },
            errorElement: 'p',
            errorClass: 'help-block',
            rules: {
                'lgxname': {
                    required: true,
                    minlength: 3
                },

                'lgxemail': {
                    required: true,
                    email: true
                },

                'lgxsubject': {
                    required: true,
                    minlength: 5
                },

                'lgxmessage': {
                    required: true,
                    minlength: 5
                }
            }
        });

        /*=========================================================================
         ===  Start Contact Form Validation And Ajax Submission END
         ========================================================================== */

        /*=========================================================================
         ===  Modal Video
         ========================================================================== */
        /* Get iframe src attribute value i.e. YouTube video url
         and store it in a variable */
        var url = $("#modalvideo").attr('src');

        /* Remove iframe src attribute on page load to
         prevent autoplay in background */
        $("#modalvideo").attr('src', '');

        /* Assign the initially stored url back to the iframe src
         attribute when modal is displayed */
        $("#lgx-modal").on('shown.bs.modal', function() {
            $("#modalvideo").attr('src', url);
        });

        /* Assign empty url value to the iframe src attribute when
         modal hide, which stop the video playing */
        $("#lgx-modal").on('hide.bs.modal', function() {
            $("#modalvideo").attr('src', '');
        });
        /*=========================================================================
         ===  Modal Video END
         ========================================================================== */

        var colorChecker = 0;
        $('.navbar-toggler').click(function() {
            if (colorChecker == 0) {
                $('.Nav-items').css({ 'background-color': 'white' });
                $('#lgx-header').css({ 'background-color': 'white' });
                $('.lgx-nav li a ').css({ 'color': '#00bacf' })
                $('#logo-image').attr('src', "/assets/img/logo.png").attr('srcset', '/assets/img/logo.png').attr('data-srcset', '/assets/img/logo.png').attr('data-src', '/assets/img/logo.png');
                colorChecker = 1;

            } else if (colorChecker == 1) {
                $('.Nav-items').css({ 'background-color': 'transparent' });
                var windowpos = $(window).scrollTop();
                if (windowpos == 0) {

                    $('#lgx-header').css({ 'background-color': 'transparent' });
                    $('#logo-image').attr('src', "/assets/img/logo-white.png").attr('data-src', "/assets/img/logo-white.png").attr('data-srcset', "/assets/img/logo-white.png").attr('srcset', "/assets/img/logo-white.png");

                }
                colorChecker = 0;

            }
        });



    }); //DOM READY


})(jQuery);
