@extends('layouts.site')

@section('content')
    <style>
        @media (max-width: 767px) {
            .btn-group{
                width: 100%!important;
            }
        }
        .btn-group.btn-group-toggle .btn.btn-secondary{
            font-size: 16px
        }
        .goNext{
            font-size: 16px;
            padding: 10px 15px;
            margin-top: 0px;
            height: 42px;
            line-height: 20px
        }
        .btn-group{
            display: inline-block;
            width: 35%;
        }
        .forminput{
            margin-top: 0px;
        }
        #recomm-form .form-row.dynamic-align{
            min-height: 350px;
        }
        .header-recommendation{
            background: #f3f6f9;
            padding: 35px;
        }
        .header-recommendation p{
            color: #4d4d4f;
            font-size: 16px;
            font-weight: bold;
        }
        .header-recommendation p span{
            color: #c35cfe;
        }
    </style>
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area m-5">
                                    <h3 class="heading" style="font-size: 2rem">
                                        <span class="heading"> {{ trans('home.questions')  }} </span>
                                    </h3>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>


    <div class="lgx-schedule">
        <div class="container-fluid">
            <div class="row justify-content-center lgx-inner">
                <div class="col-md-8">
                    <div class="lgx-tab">
                        <div class="align-items-center pb-3 boxing">
                            <div class="col-12 header-recommendation">
                                <p>
                                    @lang('home.Please read the contents of the download and make sure that the packages apply to you in')
                                    <span>@lang('home.The past two weeks')</span>
                                </p>
                            </div>

                            <!-- insert-counseling-married -->
                            <form method="POST"  id="recomm-form" action="{{route('insert-counseling-married')}}" data-parsley-validate="" class="col align-self-center px-5 py-4" style="margin-bottom: 24px;">
                                @csrf


                                     <!-- question 2 -->
                                    <div class="form-row dynamic-align">
                                        <div class="col-md-12 mt-3">
                                            <h4 for="validationDefault01" ><strong> {{ trans('home.question2')  }}</strong> </h4>
                                            <div class="form-group mt-4 px-3 dynamic-align">
                                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                    <input type="hidden" name="question[1]"  value="{{ trans('home.question2') }}" autocomplete="off">
                                                    <label class="btn btn-secondary btn-block active">
                                                        <input type="radio" name="answer[1]"  value="{{ trans('home.male') }}" autocomplete="off"> {{ trans('home.male') }}
                                                    </label>
                                                    <label class="btn btn-secondary btn-block">
                                                        <input type="radio" name="answer[1]"  value="{{ trans('home.female') }}"  autocomplete="off"> {{ trans('home.female') }}
                                                    </label>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- question 3 -->
                                    <div class="form-row dynamic-align d-none">
                                        <div class="col-md-12 mt-3">
                                            <h4 for="validationDefault01" ><strong> {{ trans('home.question3')  }}</strong> </h4>
                                            <div class="form-group mt-4 px-3 dynamic-align">
                                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                    <input type="hidden" name="question[2]"  value="{{ trans('home.question3') }}" autocomplete="off">
                                                    <label class="btn btn-secondary btn-block active">
                                                        <input type="radio" name="answer[2]" value=" {{ trans('home.male') }}" class="gender"  autocomplete="off"> {{ trans('home.male') }}
                                                    </label>
                                                    <label class="btn btn-secondary btn-block">
                                                        <input type="radio" class="gender" name="answer[2]"  value="{{ trans('home.female') }}" autocomplete="off"> {{ trans('home.female') }}
                                                    </label>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- question 4 -->
                                    <div class="form-row dynamic-align d-none">
                                        <div class="col-md-12 mt-3">
                                            <h4 for="validationDefault01" ><strong> {{ trans('home.question4')  }}</strong> </h4>
                                            <div class="form-group mt-4 px-3 dynamic-align">
                                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                    <input type="hidden" name="question[3]"  value="{{ trans('home.question4') }}" autocomplete="off">
                                                    <label class="btn btn-secondary btn-block active">
                                                        <input type="radio" name="answer[3]"  value="{{ trans('home.yes') }}"  autocomplete="off"> {{ trans('home.yes') }}
                                                    </label>
                                                    <label class="btn btn-secondary btn-block">
                                                        <input type="radio" name="answer[3]"  value="{{ trans('home.no') }}"  autocomplete="off"> {{ trans('home.no') }}
                                                    </label>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- question 5 -->
                                    <div class="form-row dynamic-align d-none">
                                        <div class="col-md-12 mt-3">
                                            <h4 for="validationDefault01" ><strong> {{ trans('home.question5')  }}</strong> </h4>
                                            <div class="form-group mt-4 px-3 dynamic-align">
                                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                    <input type="hidden" name="question[4]"  value="{{ trans('home.question5') }}" autocomplete="off">
                                                    <label class="btn btn-secondary btn-block active">
                                                        <input type="radio" name="answer[4]"  value="{{ trans('home.yes') }}"  autocomplete="off"> {{ trans('home.yes') }}
                                                    </label>
                                                    <label class="btn btn-secondary btn-block">
                                                        <input type="radio" name="answer[4]"  value="{{ trans('home.no') }}"  autocomplete="off"> {{ trans('home.no') }}
                                                    </label>
                                                    <label class="btn btn-secondary btn-block">
                                                        <input type="radio" name="answer[4]"  value="{{ trans('home.not-sure') }}"  autocomplete="off"> {{ trans('home.not-sure') }}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="form-row dynamic-align d-none">
                                        <div class="col-md-12 mt-3">
                                            <h4 class="@if(app()->getLocale()=='ar') text-right @else text-left @endif mx-3" for="validationDefault01" ><strong> {{ trans('auth.email')  }}</strong> </h4>
                                            <div class="form-group mt-4 px-3">
                                                <div class="input-group">
                                                   {{-- <div class="input-group-prepend">
                                                        <button type="button" data-step="1" class="btn btn-success goNext">@lang('home.start_now')</button>
                                                    </div>--}}
                                                    <input id="userEmail" type="email"  class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{trans('auth.enter-email')}}"
                                                           data-parsley-maxlength="30"
                                                           data-parsley-required="true"
                                                           data-parsley-required-message="هذا الحقل مطلوب"
                                                   required >
                                                </div>
                                                <label for="error-userEmail"></label>
                                                @error('email')
                                                <p class="alert alert-danger alert-dismissible fade show mt-2" role="alert">{{ $message }}
                                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </p>
                                                @enderror

                                            </div>
                                            <div class="col-md-12">
                                                <input type="hidden" name="service_type"  value="{{ trans('home.Counseling-for-those-who-are-married') }}">
                                                <input type="hidden" name="speciality_id"  value="24">

                                                 <input type="hidden" style="opacity:0" name="gender" id="gender">

                                                <button type="submit" class="lgx-btn mb-4 w-25">
                                                    {{ trans('home.send') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>


                            </form>
                            <div class="col-12">
                                <nav id="paginate-recommendation" class="d-none" aria-label="Page navigation example">
                                    <ul class="pagination">
                                        @for($x=1;$x<=4;$x++)
                                            <li class="page-item step-{{ $x }} disabled"><a data-step="{{ $x-1 }}" class="page-link change-step" href="#">{{ $x }}</a></li>
                                        @endfor
                                    </ul>
                                </nav>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>



@endsection
@section('scriptSection')
    <script>

        $('input.gender').change(function() {
            if(this.value == 'male' || this.value == ' ذكر')
            {
                $('#gender').val('male');
            }
            else
            {
                $('#gender').val('female');
            }
        });


        $("recomm-form").validate({
            errorPlacement: function(error, element) {
                console.log('error')
                console.log(error)
                console.log(element)
                console.log(element.attr( "id" ))

                $( element )
                    .closest( "form" )
                    .find( "label[for='error-" + element.attr( "id" ) + "']" )
                    .append( error );
            },
            errorElement: "span",
            rules : {
                email : {
                    required:true,
                    email:true,
                },

            },
            messages: {
                question_ar : {
                    required:"@lang('home.required_field')",
                    email:"@lang('home.email_field')",
                },

            },
        });
        function validateEmail($email) {
            var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
            return emailReg.test( $email );
        }
        $(document).ready(function(){
            $(document).on('keydown','#userEmail',function(event){
                if(event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
            $(document).on('keyup','#userEmail',function(e){
                userEmail=$(this);
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    userEmail.removeClass('is-invalid')
                    $("label[for='error-userEmail']").html('');
                    if(e.keyCode==13){
                        $('.goNext').trigger('click');
                    }
                }else{
                    userEmail.addClass('is-invalid');
                    if(userEmail.val()){
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.email_valid_field')</span>');
                    }else{
                        $("label[for='error-userEmail']").html('<span class="error">@lang('home.required_field')</span>');
                    }
                }

            });
            function goToStep(step){
                if($("#recomm-form .form-row").eq(step).length){
                    $("#recomm-form .form-row").addClass('d-none')
                    $("#recomm-form .form-row").eq(step).removeClass('d-none');
                    $("#paginate-recommendation").removeClass('d-none');
                    $("#paginate-recommendation .pagination li.active").removeClass('active');
                    $("#paginate-recommendation .step-"+(parseInt(step)+1)).addClass('active');
                }
                for (i=0;i<=step;i++){
                    $("#paginate-recommendation .pagination li").eq(i).removeClass('disabled');
                }
            }
            $(document).on('click','.goNext',function(){
                userEmail=$("#userEmail")
                if(userEmail.val()&&validateEmail(userEmail.val())){
                    step=$(this).attr('data-step');
                    console.log(step);
                    goToStep(step)
                }else{
                    userEmail.addClass('is-invalid')
                }
            });
            $(document).on('click','.change-step',function(e){
                e.preventDefault();
                step=$(this).attr('data-step');
                goToStep(step)
            })
            $(document).on('change','#recomm-form .form-row input[type="radio"]',function(){
                step=$("#recomm-form .form-row:not(.d-none)").index();
                goToStep(step)
            });
        });
    </script>
@endsection
