{{--{{ print_r(json_decode($certificate->custom_views_projects)).dd() }}--}}
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/certificates') }}">{{ Lang::get('main.certificates') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $certificate->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.certificates') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
    @section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-certificates font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.certificates') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/certificates/'.$certificate->id,'class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-md-12">
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="name_ar"  type="text" placeholder="Name Ar" value="{{$certificate->name_ar}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="name_en"  type="text" placeholder="Name En" value="{{$certificate->name_en}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="organization_ar" type="text" placeholder="Organization Ar" value="{{$certificate->organization_ar}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="organization_en" type="text" placeholder="Organization En" value="{{$certificate->organization_en}}">
                        </div>
                    </div>
{{--                    <div class="col-md-12 form-group"  style="padding-top: 10px;">--}}
{{--                        <select id="therapist_id" name="therapist_id" class="form-control">--}}
{{--                            <option value="0" selected>Select Therapist: </option>--}}
{{--                            @foreach($therapists as $id=>$title)--}}
{{--                                <option value="{{$id}}" @if($certificate->therapist_id==$id) selected @endif>{{$title}}</option>--}}
{{--                            @endforeach--}}
{{--                        </select>--}}
{{--                    </div>--}}
                    <div class="col-md-12 form-group">
                        <input class="form-control datepicker" name="start_date" value="{{$certificate->start_date}}" type="text" placeholder="From Date">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control datepicker" name="end_date" value="{{$certificate->end_date}}" type="text" placeholder="To Date">
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $( ".datepicker" ).datepicker({dateFormat: "yyyy-mm-dd"});
            $(document).on('change','#all_projects',function(){
                if($(this).is(':checked')){
                    $("#projects_ids").attr('disabled','disabled');
                }else{
                    $("#projects_ids").removeAttr('disabled')
                }
            });
        });
    </script>
@endsection
