@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-certificates font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.certificates') }}</span>
                </div>
                @if(PerUser('certificates_add'))
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/certificates/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                @endif
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('certificates_view'))
                    <div class="btn-group" role="group">

                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">Name Ar</th>
                        <th class="all">Name En</th>
                        <th class="all">Organization Ar</th>
                        <th class="all">Organization En</th>
                        <th class="all">{{ Lang::get('main.therapist') }}</th>
                        <th class="all">{{ Lang::get('main.start_date') }}</th>
                        <th class="all">{{ Lang::get('main.end_date') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('certificates_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';

            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/certificates') }}",
                    data:function(data){
                    data.active = $("input[name='status']:checked").val();
                },
            },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'name_ar', name: 'name_ar'},
                    {data: 'name_en', name: 'name_en'},
                    {data: 'organization_ar',name: 'organization_ar'},
                    {data: 'organization_en', name: 'organization_en'},
                    {data: 'therapist',
                    render: function(data, type, row){
                        if((row.therapist !=null)){
                        return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.therapist.title)
                        }else{
                            return '';
                        }
                    },

                    name: 'therapist_id'},
                    {data: 'start_date', name: 'start_date'},
                    {data: 'end_date', name: 'end_date'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });

            @if(PerUser('certificates_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.certificates') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.certificates') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/certificates') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#certificates-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
