@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-complaints font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.complaints') }}</span>
                </div>
                @if(PerUser('complaint_add'))
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/complaints/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                @endif
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('comment_view'))
                    <div class="btn-group" role="group">

                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">Client Name</th>
                        <th class="all">Client Email</th>
                        <th class="all">Title</th>
                        <th class="all">Subject</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>

                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('comment_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/complaints') }}",
                    data:function(data){
                    data.active = $("input[name='status']:checked").val();
                },
            },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'id',
                    render: function(data, type, row){
                        if(row.User !=null){
                        return row.User.name ;
                        }else{
                            return '';
                        }
                    },
                    name: 'id'},

                    {data: 'id',
                    render: function(data, type, row){
                        if(row.User !=null){
                        return row.User.email ;
                        }else{
                            return '';
                        }
                    },
                    name: 'id'},
                    {data: 'title', name: 'title'},
                    {data: 'subject', name: 'subject'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });
            @if(PerUser('comment_active'))

            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');


                if(statues){

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/complaints/activation') }}",
                        data: {"active": 1, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/complaints/activation') }}",
                        data: {"active": 0, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            @if(PerUser('complaint_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.complaints') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.complaints') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/complaints') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#complaints-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
