@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-contacts font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.contacts') }}</span>
                </div>
                @if(PerUser('contact_add'))
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/contacts/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                @endif
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('contact_view'))
                    <div class="btn-group" role="group">

                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">First Name</th>
                        <th class="all">Last Name</th>
                        <th class="all">Email</th>
                        <th class="all">Subject</th>
                        <th class="all">Contact Type</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>

                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('contact_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/contacts') }}",
                    data:function(data){
                    data.active = $("input[name='status']:checked").val();
                },
            },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'first_name', name: 'first_name'},
                    {data: 'last_name', name: 'last_name'},
                    {data: 'email', name: 'email'},
                    {data: 'subject', name: 'subject'},
                    {data: 'id',
                    render: function(data, type, row){
                        if(row.contact_type == 1){
                        return '  <h6>{{trans('home.have-service-question')}}</h6>' ;
                        }
                        if(row.contact_type == 2){
                            return '<h6>{{trans('home.registered-client')}}</h6>' ;
                            }
                            if(row.contact_type == 3){
                                return ' <h6>{{trans('home.therapist-want-join')}}</h6>' ;
                                }
                                if(row.contact_type == 4){
                                    return '   <h6>{{trans('home.registered-therapist')}}</h6>' ;
                                    }
                                    if(row.contact_type == 5){
                                        return ' <h6>{{trans('home.work-inquery')}}</h6>' ;
                                        }

                                        else{
                                            return ' <h6>{{trans('home.work-inquery')}}</h6>' ;
                                        }
                    },
                    name: 'id'},

                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });
            @if(PerUser('comment_active'))

            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');


                if(statues){

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/contacts/activation') }}",
                        data: {"active": 1, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/contacts/activation') }}",
                        data: {"active": 0, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            @if(PerUser('complaint_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.contacts') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.contacts') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/contacts') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#contacts-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
