@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/coupons') }}">{{ Lang::get('main.coupons') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.coupons') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-coupons font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.coupons') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/coupons']) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>

                    <!-- <div class="col-12 form-group">
                        <label for="used_for_session">Per Type</label>
                        <select name="per_type" id="per_type" style="width: 100%;" class="select2">
                            <option @if(old('per_type')=='per_default') selected="selected" @endif value="per_default">Default</option>
                            <option @if(old('per_type')=='per_therapist') selected="selected" @endif value="per_therapist">Therapist</option>
                        </select>
                    </div> -->


                    <div class="col-12 form-group">
                        <label for="used_for_session">Therapists</label>
                        <select name="therapists[]" id="therapists" style="width: 100%;" multiple class="select2">
                            @foreach($therapists as $therapist)
                            <option  value="{{$therapist->id}}">{{$therapist->name_e}}</option>
                            @endforeach
                        </select>
                    </div>



                    <div class="col-12 form-group">
                        <label for="type">@lang('main.type')</label>
                        <select name="type" id="type" style="width: 100%;" class="select2">
                            <option @if(old('type')=='percentage') selected="selected" @endif value="percentage">@lang('main.percentage')</option>
                        </select>
                    </div>
                    <div class="col-12 form-group">
                        <label for="used_for_session">@lang('main.currency')</label>
                        <select name="currency" id="currency" style="width: 100%;" class="select2">
                            <option @if(old('currency')=='all') selected="selected" @endif value="all">@lang('main.all')</option>
                            <option @if(old('currency')=='USD') selected="selected" @endif value="USD">USD</option>
                            <option @if(old('currency')=='EGP') selected="selected" @endif value="EGP">EGP</option>
                        </select>
                    </div>
                    <div class="col-12 form-group">
                        <label for="used_for_session">@lang('main.used_for_session')</label>
                        <select name="used_for_session" id="used_for_session" style="width: 100%;" class="select2">
                            <option @if(old('used_for_session')=='all') selected="selected" @endif value="all">@lang('main.all')</option>
                            <option @if(old('used_for_session')=='30') selected="selected" @endif value="30">30</option>
                            <option @if(old('used_for_session')=='60') selected="selected" @endif value="60">60</option>
                        </select>
                    </div>
                    <div class="col-12 form-group">
                        <label for="code">@lang('main.code')</label>
                        <input class="form-control" name="code" type="text" placeholder="@lang('main.code')"  value="{{old('code')?old('code'):Str::random(8)}}">
                    </div>
                    <div class="col-12 form-group">
                        <label for="percentage">@lang('main.percentage')</label>
                        <input class="form-control" name="percentage" type="number" min="1" max="100" placeholder="@lang('main.percentage')"  value="{{old('percentage')}}">
                    </div>

                    <div class="col-12 form-group">
                        <label for="used_limit">Per User</label>
                        <input class="form-control" name="per_user" type="text" placeholder="Per User"  value="{{old('per_user')?old('per_user'):1}}">
                        <p class="text-danger"> هنا  العميل يقدر يستخدمه كام مره  </p>
                    </div>

                    <div class="col-12 form-group">
                        <label for="used_limit">@lang('main.used_limit')</label>
                        <input class="form-control" name="used_limit" type="text" placeholder="@lang('main.used_limit')"  value="{{old('used_limit')?old('used_limit'):1}}">


                        <p class="text-danger"> (0) for Unlimited count (العدد الكلي للكوبون)</p>

                    </div>
                    <div class="col-12 form-group">
                        <label for="expired_date">@lang('main.expired_date')</label>
                        <input class="form-control datepicker" name="expired_date" type="text" placeholder="@lang('main.expired_date')"  value="{{old('expired_date')?old('expired_date'):''}}">
                    </div>

                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
