@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.educations') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.educations') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    @if(PerUser('educations_add'))
    <div class="row">
        <div class="col-md-12">
            <div class="btn-group pull-right">
                <a href="{{ URL('admin/educations/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                    <i class="fa fa-plus"></i>
                </a>
            </div>
        </div>
    </div>
    @endif
    @if(PerUser('educations_view'))
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-educations font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.educations') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="sample_1">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">Name Ar</th>
                        <th class="all">Name En</th>
                        <th class="all">Organization Ar</th>
                        <th class="all">Organization En</th>
                        <th class="all">{{ Lang::get('main.therapist') }}</th>
                        <th class="all">{{ Lang::get('main.start_date') }}</th>
                        <th class="all">{{ Lang::get('main.end_date') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $x=1;?>
                    @foreach($educations as $education)
                        <tr id="educations-{{ $education->id }}">
                            <td>{{ $x }}</td>
                            <td>{{ $education->name_ar }}</td>
                            <td>{{ $education->name_en }}</td>
                            <td>{{ $education->organization_ar }}</td>
                            <td>{{ $education->organization_en }}</td>
                            <td>{{ isset($education->therapist)?$education->therapist->title:'' }}</td>
                            <td>{{ $education->start_date }}</td>
                            <td>{{ $education->end_date }}</td>
                            <td>
                                <div class="btn-group pull-right">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">{{ Lang::get('main.action') }}
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                        @if(PerUser('educations_edit'))
                                        <li>
                                            <a href="{{ URL('admin/educations/'.$education->id.'/edit') }}">
                                                <i class="fa fa-pencil"></i> {{ Lang::get('main.edit') }} </a>
                                        </li>
                                        @endif
                                        @if(PerUser('educations_delete'))
                                        <li>
                                            <a href="javascript:;" class="delete_this" data-id="{{ $education->id }}">
                                                <i class="fa fa-trash-o"></i> {{ Lang::get('main.delete') }} </a>
                                        </li>
                                        @endif
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php $x++;?>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif
@endsection
@section('scriptCode')
    @if(PerUser('educations_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            @if(PerUser('educations_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.educations') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.educations') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/educations') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#educations-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
