@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/evaluations') }}">{{ Lang::get('main.evaluations') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>

    <h1 class="page-title"> {{ Lang::get('main.evaluations') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>

@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.evaluations') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/evaluations','class'=>"form-horizontal",'files'=>true,'id'=>'visitorCreateForm']) !!}

                <form method="POST" action="{{ url('admin/therapists/store') }}">
                    @csrf
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group"  style="padding-top: 10px;">
                            <label for="user_id">Therapist</label>
                            <select id="therapist_id" name="therapist_id" class="form-control select2">
                                @foreach($users as $user)
                                    <option value="{{$user->id}}">{{$user->name_a}}</option>
                                @endforeach
                            </select>
                        </div>

                        



                        <div class="col-md-12 form-group">
                            <label for="experiences">Rating Of Therapist</label><br>
                            <input type="radio" name="rating" value="1"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i></span><br>
                            <input type="radio" name="rating" value="2"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                            <input type="radio" name="rating" value="3"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                            <input type="radio" name="rating" value="4"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                            <input type="radio" name="rating" value="5"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                        </div>

                        <div class="col-md-12 form-group my-5">
                            <label for="experiences">Rating Comment</label><br>
                            <textarea class="form-control" name="comment" id="comment"></textarea>
                        </div>


                    </div>

                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>
                <div class="clearfix" style="height: 30px"></div>
                </form>
            </div>
        </div>
    </div>

@endsection

@section('scriptCode')
    <script type="text/javascript">

        //author:mohammed.khalf@almoasherbiz.com
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "No space please and don't leave it empty");

        jQuery.validator.addMethod("NoSpecialCharacter", function(value, element) {
            return this.optional(element) || /^[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]+[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]*$/.test(value);
        }, "No Special Characters");

        $(document).ready(function(){
            $("#visitorCreateForm").validate({
                errorPlacement: function(error, element) {
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                rules : {
                    gender : {
                        required:true,
                    },
                    mobile : {
                        required:true,
                        minlength : 10,
                    },
                    birthyear : {
                        required:true,
                        minlength : 4,
                    }
                },
                messages: {
                    gender:{
                        required:"@lang('home.required_field')",
                    },
                    mobile:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_10_field')",
                    },
                    birthyear : {
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    }
                },
            });
        });
    </script>
@endsection




