@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection

@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.evaluations') }}</span>
            </li>
        </ul>
    </div>

    <h1 class="page-title"> {{ Lang::get('main.evaluations') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
@endsection

@section('content')
    
        <table class="table text-left mx-5">
            <thead>
                <th> Therapist </th>
                <th> Rating </th>
                <th> Comment </th>
            </thead>
            <tbody>
                <tr>
                    @php
                        $th = \App\Therapist::find($selectedReviews->therapist_id);
                    @endphp
                    <td>{{ $th->name_a }}</td>
                    <td>{{ $selectedReviews->rating }}</td>
                    <td>{{ $selectedReviews->comment }}</td>
                </tr>
            </tbody>
        </table>


@endsection
