@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-evaluations font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.evaluations') }}</span>
                </div>
             
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/evaluations/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
               
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('comment_view'))
                    <div class="btn-group" role="group">

                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                            <th class="all">Therapist Name</th>
                            <th class="all">Visitor Name</th>
                            <th class="all">Client Review</th>
                            <th class="all">Client Rating</th>
                            <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('comment_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/evaluations') }}",
                    data:function(data){
                    data.active = $("input[name='status']:checked").val();
                },
            },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'id',
                    render: function(data, type, row){
                        if(row.therapist !=null ){
                            if(row.therapist.user !=null ){
                            return row.therapist.user.name
                            }else{
                                return '';
                            }
                        }else{
                            return '';
                        }
                    },

                    name: 'id'},
                    {data: 'id',
                    render: function(data, type, row){
                        if(row.visitor !=null){
                            if(row.visitor.user !=null){
                            return row.visitor.user.name
                            }else{
                                return '';
                            }
                        }else{
                            return '';
                        }
                    },

                    name: 'id'},
                    {data: 'comment', name: 'comment'},
                    {data: 'id',
                    render: function(data, type, row){
                        if(row.rating  ==1){
                            return " <span class='fa fa-star text-warning'></span>";
                        }
                        if(row.rating  ==2){
                            return " <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span>" ;
                        }
                        if(row.rating  ==3){
                            return " <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span>  <span class='fa fa-star text-warning'></span>";
                        }
                        if(row.rating  ==4){
                            return " <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span>";
                        }
                        if(row.rating  ==5){
                            return " <span class='fa fa-star text-warning'></span>  <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span> <span class='fa fa-star text-warning'></span>";
                        }
                    },

                    name: 'id'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });
            @if(PerUser('comment_active'))

            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');


                if(statues){

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/evaluations/activation') }}",
                        data: {"active": 1, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/evaluations/activation') }}",
                        data: {"active": 0, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            @if(PerUser('evaluations_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.evaluations') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.evaluations') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/evaluations') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#evaluations-"+deleted_id).remove();
                                        dialogItself.close();
                                        location.reload();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
