@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/experiences') }}">{{ Lang::get('main.experiences') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.experiences') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-experiences font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.experiences') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/experiences','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-md-12">
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="name_ar"  type="text" placeholder="Name Ar" value="{{old('name_ar')}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="name_en"  type="text" placeholder="Name En" value="{{old('name_en')}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="organization_ar" type="text" placeholder="Organization Ar" value="{{old('organization_ar')}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="organization_en" type="text" placeholder="Organization En" value="{{old('organization_en')}}">
                        </div>
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control datepicker" name="start_date"  type="text" placeholder="From Date" value="{{old('start_date')}}">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control datepicker" name="end_date"  type="text" placeholder="To Date" value="{{old('end_date')}}">
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $( ".datepicker" ).datepicker({dateFormat: "yyyy-mm-dd"});
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
