@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/faqs') }}">{{ Lang::get('main.faqs') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.faqs') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-countries font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.faqs') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/faqs','class'=>"form-horizontal",'id'=>"createFaqsForm"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-sm-12 form-group">
                        <label style="min-width: 100px">Question Arabic </label>
                        <input class="form-control" name="question_ar" type="text" placeholder="question Arabic"  value="{{old('question_ar')}}">
                        <label for="error-question_ar"></label>
                        @if ($errors->has('question_ar'))
                            <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('question_ar') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="col-sm-12 form-group">
                        <label style="min-width: 100px">Question English </label>
                        <input class="form-control" name="question_en" type="question_en" placeholder="question English"  value="{{old('question_en')}}">
                        <label for="error-question_en"></label>
                        @if ($errors->has('question_en'))
                            <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('question_en') }}</strong>
                            </span>
                        @endif
                    </div>


                    <div class="col-sm-12 form-group">
                        <label style="min-width: 100px">Answer Arabic </label>
                        <textarea class="form-control ckeditor" name="answer_ar" placeholder="answer Arabic" rows="4" cols="80">{{ old('answer_ar') }}</textarea>
                        <label for="error-answer_ar"></label>
                        @if ($errors->has('answer_ar'))
                            <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('answer_ar') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="col-sm-12 form-group">
                        <label style="min-width: 100px">Answer English </label>
                        <textarea class="form-control ckeditor" name="answer_en" placeholder="answer English" rows="4" cols="80">{{ old('answer_en') }}</textarea>
                        <label for="error-answer_en"></label>
                        @if ($errors->has('answer_en'))
                            <span class="invalid-feedback" role="alert">
                                  <strong>{{ $errors->first('answer_en') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection

@section('scriptCode')
    <script>
        $('.collapse').collapse();
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.trim().length != 0 && value != "";
        }, "No space please and don't leave it empty");

        $("#createFaqsForm").validate({
            errorPlacement: function(error, element) {
                console.log('error')
                console.log(error)
                console.log(element)
                console.log(element.attr( "id" ))

                $( element )
                    .closest( "form" )
                    .find( "label[for='error-" + element.attr( "id" ) + "']" )
                    .append( error );
            },
            errorElement: "span",
            rules : {
                question_ar : {
                    min:4,
                },

            },
            messages: {
                question_ar : {
                    required:"@lang('home.required_field')",
                },

            },
        });
    </script>
@endsection
