@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.faqs') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.faqs') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

        @if(PerUser('faqs_add'))
            <div class="row">
                <div class="col-md-12">
                    <div class="btn-group pull-right">
                        <a href="{{ URL('admin/faqs/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                            <i class="fa fa-plus"></i>
                        </a>
                    </div>
                </div>
            </div>
        @endif

        @if(PerUser('faqs_view'))
            <div class="row">
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-countries font-dark"></i>
                            <span class="caption-subject bold uppercase">{{ Lang::get('main.faqs') }}</span>
                        </div>
                        <div class="tools"> </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="sample_1">
                            <thead>
                            <tr>
                                <th class="all">#</th>
                                <th class="all">{{ Lang::get('main.question') }}</th>
                                <th class="all">{{ Lang::get('main.answer') }}</th>
                                <th class="all">{{ Lang::get('main.action') }}</th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif

@endsection
