@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
@section('content')
<!-- BEGIN PAGE HEADER-->
<!-- BEGIN PAGE BAR -->
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <span>{{ Lang::get('main.dashboard') }}</span>
        </li>
    </ul>
    <div class="page-toolbar">
        <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
            <i class="icon-calendar"></i>&nbsp;
            <span class="thin uppercase hidden-xs"></span>&nbsp;
            <i class="fa fa-angle-down"></i>
        </div>
    </div>
</div>
<!-- END PAGE BAR -->
<!-- BEGIN PAGE TITLE-->
<h1 class="page-title"> {{ Lang::get('main.dashboard') }}
    <small>{{ Lang::get('main.dashboard') }}</small>
</h1>
<!-- END PAGE TITLE-->
<!-- END PAGE HEADER-->
<!-- BEGIN DASHBOARD STATS 1-->

<style>
    .small-box{

        padding: 9px;
        font-size: 21px;
    color: white;
    }

</style>
<div class="row">
    <section class="content">

        <div class="row">

            {{-- therapists--}}
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3>{{ count($therapist)}}</h3>

                        <p>@lang('main.therapists')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user-md"></i>
                    </div>
                    @if(PerUser('therapists'))
                    <a   style="margin: 10px;color: white;" href="{{ URL('admin/therapists') }}" class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></a>
                    @else
                    <button disabled class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></button>

                    @endif
                </div>
            </div>

            {{--visitors--}}
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>{{ count($visitor)}}</h3>

                        <p>@lang('main.visitors')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    @if(PerUser('visitors'))
                    <a   style="margin: 10px;color: white;" href="{{ URL('admin/visitors') }}" class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></a>
                    @else
                    <button disabled class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></button>

                    @endif
                </div>
            </div>

            {{--profiles--}}
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>{{ count($profiles)}}</h3>

                        <p>@lang('main.profiles')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user"></i>
                    </div>
                    @if(PerUser('profiles'))
                    <a   style="margin: 10px;color: white;" href="{{ URL('admin/profiles') }}" class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></a>
                    @else
                    <button disabled class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></button>

                    @endif
                </div>
            </div>

            {{--users--}}
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>{{ count($user)}}</h3>

                        <p>@lang('main.users')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    @if(PerUser('users'))
                    <a
                    style="margin: 10px;color: white;"
                    href="{{ URL('admin/users') }}" class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></a>
              @else
              <button disabled class="small-box-footer">@lang('main.view') <i class="fa fa-arrow-circle-right"></i></button>

              @endif
                </div>
            </div>

        </div><!-- end of row -->



    </section><!-- end of content -->
</div>













<div class="row">
    <div class="col-md-12" >

        <div class="card" style="background-color: white;margin: 19px;">

        <!-- /.card-header -->
        <div class="card-body p-0">
            @include('admin.therapistdash')
        </div>
        <!-- /.card-body -->
        <div class="card-footer clearfix">

        <!--   <a href="javascript:void(0)" class="btn btn-sm btn-secondary float-right">View All Orders</a> -->
        </div>
        <!-- /.card-footer -->
        </div>
        </div>






    </div>

@endsection
