@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/main_focus') }}">{{ Lang::get('main.main_focus') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.main_focus') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-main_focus font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.main_focus') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/main_focus','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="title_ar" type="text" placeholder="Title arabic" value="{{old('title_ar')}}">
                    </div>

                    <div class="col-md-12 form-group">
                        <input class="form-control" name="title_en" type="text" placeholder="Title English" value="{{old('title_en')}}">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="sort" type="number" placeholder="sort" value="{{old('sort')}}">
                    </div>
                    <div class="form-group col-lg-12 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="active" value="1" checked data-size="small" data-on-color="success" data-on-text="active" data-off-color="default" data-off-text="unActive">
                    </div>
                    <div class="col-md-12 form-group">
                        <label for="parent_id">Parent</label>
                        <select id="parent_id" name="parent_id" class="form-control" style="margin-bottom: 20px;">
                            <option value="0">Select Parent: </option>
                            @foreach($parents as $id=>$title)
                                <option value="{{$id}}" @if(old('parent_id')==$id) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
