{{--{{ print_r(json_decode($payment_method->custom_views_projects)).dd() }}--}}
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/payment_methods') }}">{{ Lang::get('main.payment_methods') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $payment_method->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.payment_methods') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
    @section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-payment_methods font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.payment_methods') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/payment_methods/'.$payment_method->id,'class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="title" type="text" placeholder="Title" value="{{$payment_method->title}}">
                    </div>
                    <div class="form-group col-lg-12">
                        <label style="min-width: 100px">Description </label>
                        <textarea class="form-control ckeditor" name="description" placeholder="Description" rows="4" cols="80">{{$payment_method->description}}</textarea>
                    </div>
                    <div class="form-group col-lg-12 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="active" value="1" @if($payment_method->active==1) checked @endif data-size="small" data-on-color="success" data-on-text="active" data-off-color="default" data-off-text="unActive">
                    </div>
                    <div class="text-center">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px; border: none">
                                <img src="{{ asset('payment_methods/'.$payment_method->picture) }}" alt="" /> </div>
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                            <div >
                                <span class="btn default btn-file">
                                    <span class="fileinput-new"> {{ Lang::get('main.select_image') }} </span>
                                    <span class="fileinput-exists"> {{ Lang::get('main.change') }} </span>
                                    <input type="file" name="picture"> </span>
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> {{ Lang::get('main.remove') }} </a>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
                if($(this).is(':checked')){
                    $("#projects_ids").attr('disabled','disabled');
                }else{
                    $("#projects_ids").removeAttr('disabled')
                }
            });
        });
    </script>
@endsection
