@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/therapists') }}">{{ Lang::get('main.therapists') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.therapists') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.therapists') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/therapists','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group"  style="padding-top: 10px;">
                            <label for="user_id">User </label>
                            <select id="user_id" name="user_id" class="form-control">
                                @foreach($users as $id=>$title)
                                    <option value="{{$id}}" @if($id==old('user_id')) selected @endif>{{$title}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="name_a" type="text" placeholder="Name Ar" value="{{old('name_a')}}">
                        </div>
                         <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="name_e" type="text" placeholder="Name En" value="{{old('name_e')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="license_no" type="text" placeholder="License no" value="{{old('license_no')}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="license_org" type="text" placeholder="License org" value="{{old('license_org')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="main_specialty_ar" type="text" placeholder="Main specialty Arabic" value="{{old('main_specialty_ar')}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  name="main_specialty_en" type="text" placeholder="Main specialty English" value="{{old('main_specialty_en')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="price30"  type="text" placeholder="Price 30 Egyptian Pound" value="{{old('price30')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="price60"  type="text" placeholder="Price 60 Egyptian Pound" value="{{old('price60')}}">
                        </div>

                        <!-- price per dollar -->
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="thirty_price_dollar"  type="text" placeholder="Price 30 Dollar" value="{{old('thirty_price_dollar')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="sixty_price_dollar"  type="text" placeholder="Price 60 Dollar" value="{{old('sixty_price_dollar')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control datepicker" name="birth"  type="text" placeholder="Birth date" value="{{old('birth')}}">
                        </div>

                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="main_focus_ar"  type="text" placeholder="Main Focus Arabic" value="{{old('main_focus_ar')}}">
                        </div>
                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" name="main_focus_en"  type="text" placeholder="Main Focus English" value="{{old('main_focus_en')}}">
                        </div>
                        <div class="form-group">
                            <label style="min-width: 100px">Description Arabic </label>
                            <textarea class="form-control ckeditor" name="description_ar" placeholder="Description Arabic" rows="4" cols="80">{{old('description_ar')}}</textarea>
                        </div>

                        <div class="form-group">
                            <label style="min-width: 100px">Description English </label>
                            <textarea class="form-control ckeditor" name="description_en" placeholder="Description Arabic" rows="4" cols="80">{{old('description_en')}}</textarea>
                        </div>


                        <div class="form-group">
                            <label style="min-width: 100px">Summary Arabic </label>
                            <textarea class="form-control ckeditor" name="summery_ar" placeholder="Summary Arabic" rows="4" cols="80">{{old('summery_ar')}}</textarea>
                        </div>

                        <div class="form-group">
                            <label style="min-width: 100px">Summary English </label>
                            <textarea class="form-control ckeditor" name="summery_en" placeholder="Summary English" rows="4" cols="80">{{old('summery_en')}}</textarea>
                        </div>

                    </div>
                    <div class="col-md-12 form-group"  style="padding-top: 10px;">
                        <label for="gender">Gender </label>
                        <select id="gender" name="gender" class="form-control" >
                                <option value="male" @if(old('gender')=='male') selected @endif>Male</option>
                                <option value="female" @if(old('gender')=='female') selected @endif>Female</option>
                        </select>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="language_id">Country </label>
                        <select id="country_id" name="country_id" class="form-control">
                            @foreach($countries as $id=>$title)
                                <option value="{{$id}}" @if($id==old('country_id')) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                    </div>




                    <div class="col-md-12 form-group">
                        <label for="language_id">Languages </label>
                        <select id="language_id" name="language_id" class="form-control" >
                            @foreach($languages as $id=>$title)
                                <option value="{{$id}}"  selected>{{$title}}</option>
                            @endforeach
                        </select>
                    </div>


                    <div class="col-md-12 form-group">
                        <label for="certificates">Certificates Arabic </label>
                        <textarea class="form-control ckeditor" name="certifications_ar" placeholder="Certificates Arabic" rows="4" cols="80">{{old('certifications_ar')}}</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="certificates">Certificates English </label>
                        <textarea class="form-control ckeditor" name="certifications_en" placeholder="Certificates English" rows="4" cols="80">{{old('certifications_en')}}</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="experiences">Experience Arabic </label>
                        <textarea class="form-control ckeditor" name="experience_ar" placeholder="Certificates Arabic" rows="4" cols="80">{{old('experience_ar')}}</textarea>
                    </div>


                    <div class="col-md-12 form-group">
                        <label for="experiences">Experience English </label>
                        <textarea class="form-control ckeditor" name="experience_en" placeholder="Certificates English" rows="4" cols="80">{{old('experience_en')}}</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="specialties">Specialties </label>
                        <select id="specialties" name="specialties[]" class="form-control select2" multiple>
                            @foreach($specialties as $id=>$title)
                                <option value="{{$id}}" @if(is_array(old('specialties')) && in_array($id,old('specialties'))) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-lg-12 text-center">
                        <input type="checkbox" class="make-switch" name="active" value="1" checked data-size="small" data-on-color="success" data-on-text="active" data-off-color="default" data-off-text="unActive">
                    </div>
                    <div class="form-group col-lg-12">
                        <div class="custom-file">
                            <input type="file" name="resume" class="custom-file-input" id="customFile">
                            <label class="custom-file-label"  for="customFile">Upload Resume</label>
                        </div>
                    </div>
                    <div class="text-center">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px; border: none"></div>
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                            <div >
                                <span class="btn default btn-file">
                                    <span class="fileinput-new"> {{ Lang::get('main.select_image') }} </span>
                                    <span class="fileinput-exists"> {{ Lang::get('main.change') }} </span>
                                    <input type="file" name="picture"> </span>
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> {{ Lang::get('main.remove') }} </a>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $( ".datepicker" ).datepicker({dateFormat: "dd-mm-yyyy"});
            $('.select2').select2();
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
