
<br>
<br>
<br>
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection

@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark" style="padding-right: 10px;">
                    <i class="icon-payments font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.payments') }}</span>
                </div>
                <div class="btn-group pull-left">
                    <a href="{{ URL('admin/payments/export') }}" id="sample_editable_1_new" class="btn green"> Export data
                        <i class="fa fa-file-export"></i>
                    </a>
                </div>
                <div class="tools"> </div>


            </div>
            <div class="portlet-body">
                @if(PerUser('payments_view'))

                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>

                        <th class="all">{{ Lang::get('main.therapist-name') }}</th>
                        <th class="all">{{ Lang::get('main.visitors') }}</th>
                        <th class="all">{{ Lang::get('main.session_date') }}</th>
                        <th class="all">{{ Lang::get('main.states') }}</th>
                        <th class="all">{{ Lang::get('main.approved_date') }}</th>
                        <th class="all">{{ Lang::get('main.price') }}</th>
                        <th class="all">{{ Lang::get('main.therapist_amount') }}</th>
                        <th class="all">{{ Lang::get('main.type') }}</th>
                        <th class="all">{{ Lang::get('main.payment_method') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('payments_view'))
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script>
        var token="{{ csrf_token() }}";
        $(document).ready(function(){

            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                "order": [[ 0, "desc" ]],

                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/payments') }}",

            },

                columns: [
                    {data: 'id', name: 'id'},

                    {data: 'therapist', name: 'therapist'},

                    {data: 'user_id',
                    render: function(data, type, row){
                        if(row.user != null){

                            return "<a target='_blank' href='" + 'visitors/' + row.user.id + '/edit' + "' >"+row.user.name+"</a>";

                                }else{
                                    return '';
                                }

                    },
                    name: 'user.name'},

                    {data: 'session_id',
                    render: function(data, type, row){
                        if(row.sessions != null){

                            var d = new Date(row.sessions.start_time);
                            result = d.getFullYear()+"/"+(d.getMonth()+1)+"/"+d.getDate() +
                            " "+ d.getHours()+":"+d.getMinutes()+":"+
                            d.getSeconds()+""+d.getMilliseconds();
                            return "<a style='"+(row.sessions.deleted_at?'text-decoration: line-through;color: red;':'')+"' target='_blank' href='" + 'sessions/' + row.sessions.id + '/edit' + "' >"+result+"</a>";
                                }else{
                                    return row.sessions ;
                                }

                    },
                    name: 'session_id'},


                    {data: 'status', name: 'status',render: function(data, type, row,result){
                            return '<span id="status-'+row.id+'">'+row.status+'</span>';

                        }},
                    {data: 'approved_date',
                    render: function(data, type, row,result){
                    if(row.approved_date){
                        var d = new Date(row.approved_date);
                        result = d.getFullYear()+"/"+(d.getMonth()+1)+"/"+d.getDate() +
                            " "+ d.getHours()+":"+d.getMinutes()+":"+
                            d.getSeconds()+" "+d.getMilliseconds();
                        return result;
                    }
                    return '';

                    }
                    , name: 'approved_date'},
                    {data: 'price', name: 'price',render: function(data, type, row,result){
                            return ((row.currancy=='EGP')?row.price:row.price_dolar)+row.currancy

                        }
                        },
                    {data: 'therapist_amount', name: 'therapist_amount',render: function(data, type, row,result){
                            return row.therapist_amount+row.currancy

                        }},

                    




                    {data: 'topic',
                    render: function(data, type, row){
                        if(row.sessions != null){
                            if (row.sessions.topic == 'test')
                            {
                                return "<span style='background: #615bb9;padding: 5px;font-size: 12px;font-weight: 700;color: #fff;'>Test</span>";
                            }
                            else
                            {
                                return "<span style='background: #26c281;padding: 5px;font-size: 12px;font-weight: 700;color: #fff;'>Real</span>";
                            }

                            }else{
                                return row.sessions ;
                            }

                    },
                    name: 'topic'},

                     {data: 'payment_method', name: 'payment_method'},

                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                "lengthMenu": [
                    [10, 20, 50, 100, 150],
                    [10, 20, 50, 100, 150] // change per page values here
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });


        });



        function approve(id,btn) {

            var url = '{{URL::to("admin/payments")}}' + "/" + id+"/edit";
            var menu = $('#menu').val();
            document.getElementById("approve").disabled = true;

            data = {
                id: id,
                _token: "{{csrf_token()}}",
            };
            $.ajax({
                url: url,
                type: 'get',
                dataType: 'json',
                data: data,
                success: function(response) {

                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);

                    swal("Approved successfully!")
                    document.getElementById("approve").disabled = false;


                },
                error: function(response) {
                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);
                    swal("Approved successfully!")
                    document.getElementById("approve").disabled = false;


                }
            });
        }


        function disapprove(id,btn) {
            var url = '{{URL::to("viewcontent")}}' + "/" + id;
            var menu = $('#menu').val();

            document.getElementById("disapprove").disabled = true;

            data = {
                id: id,
                _token: "{{csrf_token()}}",
            };
            $.ajax({
                url: url,
                type: 'get',
                dataType: 'json',
                data: data,
                success: function(response) {
                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);
                    swal("disApproved successfully!")
                    document.getElementById("disapprove").disabled = false;

                },
                error: function(response) {
                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);
                    swal("disApproved successfully!")
                    document.getElementById("disapprove").disabled = false;


                }
            });
        }
        $(document).on('click','.makeApproved',function(e){
            el=$(this)
            el.addClass('loading').attr('disabled','disabled');
            payment_id=$(this).attr('data-id');
            $.ajax({
                type: "POST",
                url: "{{ URL('admin/payments') }}/"+payment_id+'/makeApproved',
                data: {_token:token},
                success: function (msg) {
                    el.removeClass('loading').removeAttr('disabled','disabled');
                    if(msg.success){
                        el.parent().find('.makeCanceled').remove();
                        el.remove();
                        $("#status-"+payment_id).html('@lang('main.approved')')
                    }
                }
            });
        });
        $(document).on('click','.makeCanceled',function(e){
            el=$(this)
            el.addClass('loading').attr('disabled','disabled');
            payment_id=$(this).attr('data-id');
            $.ajax({
                type: "POST",
                url: "{{ URL('admin/payments') }}/"+payment_id+'/makeCanceled',
                data: {_token:token},
                success: function (msg) {
                    el.removeClass('loading').removeAttr('disabled','disabled');
                    if(msg.success){
                        el.parent().find('.makeApproved').remove();
                        el.remove();
                        $("#status-"+payment_id).html('@lang('main.canceled')')
                    }
                }
            });
        });
    </script>







    @endif
    @endsection
