@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/scales') }}">{{ Lang::get('home.psychological-test') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('home.psychological-test') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-scales font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('home.psychological-test') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/scales','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="name_ar" type="text" placeholder="Name arabic">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="name_en" type="text" placeholder="Name english">
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="description_ar">Description arabic</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="description_en">Description english</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="nominations_ar">nominations arabic</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="nominations_en">nominations english</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="instructions_ar">instructions arabic</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="instructions_en">instructions english</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="note_ar">note arabic</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="note_en">note english</textarea>
                    </div>


                    <div class="col-md-12 form-group">
                        <input class="form-control" name="duration_ar" type="text" placeholder="duration arabic">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="duration_en" type="text" placeholder="duration english">
                    </div>

                   
                  
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
