@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/scales') }}">{{ Lang::get('home.psychological-test') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $scale->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('home.psychological-test') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
    @section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-scales font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('home.psychological-test') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/scales/'.$scale->id,'class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="name_ar" type="text" placeholder="Name arabic" value="{{ $scale->name_ar }}">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="name_en" type="text" placeholder="Name english" value="{{ $scale->name_en }}">
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="description_ar">{!!$scale->description_ar!!}</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="description_en">{!!$scale->description_en!!}</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="nominations_ar">{!!$scale->nominations_ar!!}</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="nominations_en">{!!$scale->nominations_en!!}</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="instructions_ar">{!!$scale->instructions_ar!!}</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="instructions_en">{!!$scale->instructions_en!!}</textarea>
                    </div>

                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="note_ar">{!!$scale->note_ar!!}</textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <textarea class="form-control" name="note_en">{!!$scale->note_en!!}</textarea>
                    </div>


                    <div class="col-md-12 form-group">
                        <input class="form-control" name="duration_ar" value="{{ $scale->duration_ar }}" type="text" placeholder="duration arabic">
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="form-control" name="duration_en" value="{{ $scale->duration_en }}" type="text" placeholder="duration english">
                    </div>

                   
                  
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
