@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-services font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.services') }}</span>
                </div>
                @if(PerUser('services_add'))
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/services/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                @endif
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('services_view'))
                    <div class="btn-group" role="group">
                        <input type="radio" class="btn-check hidden" name="status" id="all" value="all" autocomplete="off" >
                        <label class="btn btn-primary" for="all">All</label>

                        <input type="radio" class="btn-check hidden " name="status" id="active" value="active" autocomplete="off" checked>
                        <label class="btn btn-primary active" for="active">Active</label>

                        <input type="radio" class="btn-check hidden" name="status" id="unactive" value="unactive" autocomplete="off">
                        <label class="btn btn-primary" for="unactive">Un Active</label>
                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">{{ Lang::get('main.title_ar') }}</th>
                        <th class="all">{{ Lang::get('main.title_en') }}</th>
                        <th class="all">{{ Lang::get('main.active') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('services_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/services') }}",
                    data:function(data){
                    data.active = $("input[name='status']:checked").val();
                },
            },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'title_ar', name: 'title_ar'},
                    {data: 'title_en', name: 'title_en'},
                    {data: 'active', name: 'active', searchable: false},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });
            @if(PerUser('services_active'))

            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');


                if(statues){

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/services/activation') }}",
                        data: {"active": 1, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/services/activation') }}",
                        data: {"active": 0, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            @if(PerUser('services_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.services') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.services') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/services') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#services-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
