@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/sessions') }}">{{ Lang::get('main.sessions') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.sessions') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-sessions font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.sessions') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/sessions','class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-md-12 form-group"  style="padding-top: 10px;">
                        <select id="therapist_id" name="therapist_id" class="form-control" >
                            <option value="0" selected>Select therapist: </option>
                            @foreach($therapists as $id=>$title)
                                <option value="{{$id}}" @if(old('therapist_id')==$id) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-12 form-group">
                        <select id="visitor_id" name="visitor_id" class="form-control">
                            <option value="0" selected>Select Visitor: </option>
                            @foreach($visitors as $id1=>$title1)
                                <option value="{{$id1}}" @if(old('visitor_id')==$id1) selected @endif>{{$title1}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-12 form-group">
                        <select id="type" name="type" class="form-control">
                            <option value="0" selected>Select Type: </option>
                                <option value="30" @if(old('type')==30) selected @endif>30</option>
                                <option value="60" @if(old('type')==60) selected @endif>60</option>
                        </select>
                    </div>
                    <div class="col-md-12 form-group">
                        <input class="datetimepicker form-control" name="start_time"  placeholder="Start Time" value="{{old('start_time')}}">
                    </div>
                    <div class="form-group col-lg-12 text-center" style="margin-top:25px;">
                        <label for="status">status</label>
                        <input type="checkbox" class="make-switch" id="status" name="status" value="0" data-size="small" data-on-color="success" data-on-text="1" data-off-color="default" data-off-text="0">
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $('.datetimepicker').datetimepicker();
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
