@extends('admin.layouts.app')
@section('pageTitle')
@endsection
@section('content')
    <style>
        .search-wrapper input {
            border-radius: 50px !important;
            padding: 23px !important;
            transition: none !important;
            border: 1px solid #ddd;
        }
        .search-wrapper .form-group {
            width: 100% !important;
            transition: none !important;
            border-radius: 50px !important;
        }
        .search-wrapper input, .search-wrapper .form-group {
            width: 100% !important;
            transition: none !important;
            border-radius: 50px !important;
        }
        /*.hide-loading {
            display: none !important;
        }
        .loading {
            position: absolute;
            z-index: 999;
            !* height: 2em; *!
            !* width: 2em; *!
            !* overflow: visible; *!
            margin-right: auto;
            margin-left: auto;
            right: 0;
            left: 0;
            !* right: auto; *!
            text-align: center;
        }*/
        .loading {
            position: relative;
        }
        .loading::after {
            position: absolute;
            background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
            background-image: url(https://cf2.s3.souqcdn.com/public/style/img/loading.gif);
            background-repeat: no-repeat;
            background-position: center center;
            background-color: rgba(250, 250, 250, .8);
            background-size: 1.7857142857rem auto;
        }
        .loading::after {
            display: block!important;
            width: 100%;
            height: 100%;
            left: 0;
            top: 0;
            z-index: 148;
            content: ' '!important;
            line-height: 0;
        }
        #searchResult{
            background: #73bffe42;
            border-radius: 25px!important;
        }
        #sessions-blocks button .fa{
            display: none;
        }
        #sessions-blocks button.selected {
            border-color: #fff;
            color: #666;
            background-color: #fff;
        }
        #sessions-blocks button .selected-text{
            display: none;
        }
        #sessions-blocks button.selected .selected-text{
            display: inline-block;
        }
        #sessions-blocks button.selected .select-text{
            display: none;
        }

        #sessions-blocks button.selected .fa{
            color:green;
            display: inline-block;
        }
    </style>
    <div id="errorMessages" style="position: fixed; top: 0;right: 0;left: 0; z-index: 9999999999; text-align: center"></div>
    <section id="newDashboard" class="new-dashboard" style="margin-top: 40px;">

            <div class="search-wrapper text-center">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="logo-wrapper">
                            <img src="{{URL('assets/img/logo.png')}}" alt="logo"
                                 class="logo-default">
                        </div>
                    </div>
                    <div class="col-md-8 col-md-offset-2" style="margin-bottom: 25px;">
                        <form class="navbar-form" onsubmit="return false">
                            <div class="form-group">
                                <input type="text" class="form-control search-bar-custom" id="customerEmail"
                                       placeholder="Search" autofocus>
                            </div>
                        </form>
                        <div class="search-result clearfix" id="searchResult"></div>
                        <!--                <div id="errorMessages"></div>-->
                    </div>
                    <div id="logo-wrapper-right" class="col-md-2 hidden" style="text-align: left; margin-top:6px;">
                        <img src="{{URL('assets/img/logo.png')}}" alt="logo"
                             class="logo-default" style="width: 50%;">
                    </div>

                </div>
            </div>
        <form action="" onsubmit="return false" id="bookingNowForm">
            @csrf
            <input type="hidden" name="visitor_id" id="visitor_id">

            <div id="therapists-html" class="col-lg-12 hidden">
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Therapists</label>
                    <select name="therapist_id" style="width: 100%;" class="select2" id="therapist_id">
                        <option value="">Select Therapist</option>
                        @foreach(\App\Therapist::active()->pluck('name_e','id')->toArray() as $id=>$name)
                            <option value="{{ $id }}">{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div id="select-date" class="hidden">
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Dates</label>
                    <select name="date" style="width: 100%;" class="select2" id="date">
                    </select>
                </div>
            </div>

            <div id="real_or_test" class="hidden">
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Add Session as a...</label>
                    <select name="real_or_test" style="width: 100%;" class="select2" id="real_or_test2">
                        <option value="real">Real</option>
                        <option value="test">Test</option>
                    </select>
                </div>
            </div>

            <div id="select-currency" class="hidden">
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Currency</label>
                    <select name="currency" style="width: 100%;" class="select2" id="currency">
                        <option value="">Select Currency</option>
                        <option value="EGP">EGP</option>
                        <option value="USD">USD</option>
                    </select>
                </div>
            </div>






            <div id="sessions-blocks" class="col-lg-12 hidden">

            </div>
            <div id="payment-method" class="col-lg-12 hidden">
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Payment Method</label>
                    <select name="payment_method" style="width: 100%;" class="select2" id="payment_method">
                        <option value="Vodafone">Vodafone</option>
                        <option value="bank">Bank</option>
                    </select>
                </div>
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Coupon</label>
                    <input name="coupon" style="width: 100%;" class="form-control">
                </div>
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label for="">Payment Status</label>
                    <select name="status" style="width: 100%;" class="select2" id="status">
                        <option value="approved">Approved</option>
                        <option value="pending">Pending</option>
                    </select>
                </div>
                <div class="col-lg-12 text-center">
                    <button class="btn btn-success" id="bookingNow" type="submit">Save</button>
                </div>
            </div>
            <div id="errorMessage" class="col-lg-12">

            </div>
        </form>





        <div class="clearfix"></div>

    </section>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(".select2").select2();

            $(".menu-toggler.sidebar-toggler").trigger('click');

            animateCSS('#newDashboard','bounceIn');
            $(document).on('keypress','#customerEmail',function(e){
                if(e.which == 13) {
                    $("#newDashboard").addClass('loading')
                    emailOrPhone=$(this).val();
                    $.ajax({
                        type: "GET",
                        url: "{{ route('sessions_booking') }}",
                        data: {"getVisitor":true,emailOrPhone},
                        success: function (msg) {
                            $("#newDashboard").removeClass('loading')
                            $("#searchResult").html(msg.html);
                            animateCSS('#searchResult','bounceIn');
                            if(msg.success){
                                $("#therapists-html").removeClass('hidden');
                                $("#visitor_id").val(msg.visitor_id);
                                animateCSS('#therapists-html','bounceIn');
                            }
                            $("#errorMessage").html('');

                        }
                    });
                }
            });
            $(document).on('change','#therapist_id',function () {

                therapist_id=$(this).val();
                if(therapist_id){
                    $("#newDashboard").addClass('loading');
                    $.ajax({
                        type: "GET",
                        url: "{{ route('sessions_booking') }}",
                        data: {"getDatesOfTherapist":true,therapist_id},
                        success: function (msg) {
                            $("#newDashboard").removeClass('loading')
                            $("#select-date").removeClass('hidden')
                            $("#date").html(msg.html);
                            $("#currency").val('')
                            $("#select-currency").addClass('hidden');

                            $("#sessions-blocks").addClass('hidden');
                            $("#payment-method").addClass('hidden');
                            $('select.select2').each(function(){
                                $(this).select2('destroy')
                            });
                            $('select.select2').select2()
                            animateCSS('#select-date','bounceIn');
                            $("#errorMessage").html('');
                        }
                    });
                }

            });
            $(document).on('change','#date',function () {
                therapist_id=$("#therapist_id").val();
                date=$(this).val();
                $("#select-currency").removeClass('hidden')
                $("#real_or_test").removeClass('hidden');
                $("#currency").val('')
                $('select.select2').each(function(){
                    $(this).select2('destroy')
                });
                $('select.select2').select2()
                $("#sessions-blocks").addClass('hidden');
                $("#payment-method").addClass('hidden');
                {{--if(therapist_id&&date){--}}
                {{--    $("#newDashboard").addClass('loading');--}}
                {{--    $.ajax({--}}
                {{--        type: "GET",--}}
                {{--        url: "{{ route('sessions_booking') }}",--}}
                {{--        data: {"getSessionsByDate":true,therapist_id,date},--}}
                {{--        success: function (msg) {--}}
                {{--            $("#newDashboard").removeClass('loading')--}}
                {{--            $("#sessions-blocks").removeClass('hidden')--}}
                {{--            $("#sessions-blocks").html(msg.html)--}}
                {{--            animateCSS('#sessions-blocks','bounceIn');--}}
                {{--            $("#errorMessage").html('');--}}
                {{--        }--}}
                {{--    });--}}
                {{--}--}}

            });
            $(document).on('change','#currency',function(){
                therapist_id=$("#therapist_id").val();
                date=$("#date").val();
                currency=$("#currency").val();
                if(therapist_id&&date&&currency){
                    $("#newDashboard").addClass('loading');
                    $.ajax({
                        type: "GET",
                        url: "{{ route('sessions_booking') }}",
                        data: {"getSessionsByDate":true,therapist_id,date,currency},
                        success: function (msg) {
                            $("#newDashboard").removeClass('loading')
                            $("#sessions-blocks").removeClass('hidden')
                            $("#sessions-blocks").html(msg.html)
                            animateCSS('#sessions-blocks','bounceIn');
                            $("#errorMessage").html('');
                        }
                    });
                }
            })
            $(document).on('click','#sessions-blocks button',function(){
                $("#sessions-blocks button").removeClass('selected');
                $(this).addClass('selected');
                $("#session_id").val($(this).attr('data-id'));
                $("#payment-method").removeClass('hidden');
                animateCSS('#payment-method','bounceIn');
                $([document.documentElement, document.body]).animate({
                    scrollTop: $("#payment-method").offset().top
                }, 2000);
            });
            $(document).on('click','#bookingNow',function(){
                $("#newDashboard").addClass('loading');
                $.ajax({
                    type: "POST",
                    url: "{{ URL('admin/sessions/booking') }}",
                    data: $("#bookingNowForm").serialize(),
                    success: function (msg) {

                        $("#newDashboard").removeClass('loading')
                        if(msg.success){
                            $("#bookingNowForm")[0].reset();
                            $("#payment-method,#sessions-blocks,#select-date,#select-currency").addClass('hidden');
                            $('select.select2').each(function(){
                                $(this).select2('destroy')
                            });
                            $('select.select2').select2()
                        }

                       $("#errorMessage").html('<div id="error-message-data" class="alert alert-'+(msg.success?'success':'danger')+'">'+msg.message+'</div>');
                        setTimeout(function(){
                        animateCSS('#error-message-data','flipOutX').then(()=>$("#errorMessage").html(''));
                        },5000);

                    }
                });
            });

        })
    </script>
@endsection
