@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .daterange-filter {
            background: none repeat scroll 0 0 #FFFFFF;
            border: 1px solid #CCCCCC;
            cursor: pointer;
            padding: 5px 10px;
        }
    </style>
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-sessions font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.sessions') }}</span>
                </div>
                @if(PerUser('sessions_add'))
                    <div class="btn-group pull-right"  style="margin-left: 10px;">
                        <a href="{{ URL('admin/sessions/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                            <i class="fa fa-plus"></i>
                        </a>
                    </div>
                @endif
                @if(PerUser('sessions_booking'))
                    <div class="btn-group pull-right">
                        <a href="{{ URL('admin/sessions/booking') }}" id="sample_editable_1_new" class="btn green"> Booking
                            <i class="fa fa-plus"></i>
                        </a>
                    </div>
                @endif
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('sessions_view'))
                    <div class="btn-group" role="group">

                    </div>
                    <div class="pull-left col-lg-12">
                        <div class="form-group col-lg-3">
                            <select name="therapist_id" style="width:100%;" class="form-control" id="therapist_id"></select>
                        </div>
                        <div class="form-group col-lg-4">
                            <div id="date-filter" class="daterange-filter reportrange">
                                <i class="fa fa-calendar"></i>
                                <span>{{ date('F d, Y',strtotime('first day of this month')) }} - {{ date('F d, Y',strtotime('last day of this month')) }}</span> <b class="caret"></b>
                            </div>
                            <input type="hidden" name="from_date" class="from_date" value="{{ date('Y-m-d',strtotime('first day of this month')) }}">
                            <input type="hidden" name="to_date" class="to_date" value="{{ date('Y-m-d',strtotime('last day of this month')) }}">
                        </div>
                        <div class="form-group col-lg-3">
                            <select name="session_status[]" style="width:100%;" multiple class="form-control select2" id="session_status">
                                <option value="available">@lang('main.available')</option>
                                <option value="reserved">@lang('main.reserved')</option>
                                <option value="cancelled">@lang('main.cancelled')</option>
                                <option value="requested">@lang('main.requested')</option>
                                <option value="suggested">@lang('main.suggested')</option>
                                <option value="visitor_cancelled">@lang('main.visitor_cancelled')</option>
                                <!-- <option value="closed">@lang('main.closed')</option> -->
                                <option value="session_done">@lang('main.session_done')</option>
                                <option value="therapist_not_start">@lang('main.therapist_not_start')</option>
                            </select>
                        </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                        <thead>
                        <tr>
                            <th class="all">#</th>
                            <th class="all">{{ Lang::get('main.therapists') }}</th>
                            <th class="all">{{ Lang::get('main.visitors') }}</th>
                            <th class="all">{{ Lang::get('main.type') }}</th>
                            <th class="all">{{ Lang::get('main.start_time') }}</th>
                            <th class="all">{{ Lang::get('main.rating') }}</th>

                            <th class="all"> Session Done </th>

                            <th class="all">{{ Lang::get('main.action') }}</th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('sessions_view'))
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

        <script>
            $(document).ready(function(){
                token= '{{ csrf_token() }}';
                $('#date-filter').daterangepicker({
                        {{--startDate: moment().startOf('month'),--}}
                            {{--endDate: moment().endOf('month'),--}}
                            {{--minDate: '01/01/2020',--}}
                            {{--maxDate: '{{ date('m/d/Y') }}',--}}
                        dateLimit: { days: 60 },
                        showDropdowns: true,
                        showWeekNumbers: true,
                        timePicker: false,
                        timePickerIncrement: 1,
                        timePicker12Hour: true,
                        ranges: {
                            '@lang('home.Today')': [moment(), moment()],
                            '@lang('home.Yesterday')': [moment().subtract('days', 1), moment().subtract('days', 1)],
                            '@lang('home.Last 7 Days')': [moment().subtract('days', 6), moment()],
                            '@lang('home.Last 30 Days')': [moment().subtract('days', 29), moment()],
                            '@lang('home.This Month')': [moment().startOf('month'), moment().endOf('month')],
                            '@lang('home.Last Month')': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
                            @for($x=1;$x<=date('m');$x++)
                            '@lang('home.'.date('F', mktime(0, 0, 0, $x, 10)))': [new Date('{{ date('Y-m-d H:i:s',strtotime('first day of '.date('F', mktime(0, 0, 0, $x, 10)))) }}'), new Date('{{ date('Y-m-d H:i:s',strtotime('last day of '.date('F', mktime(0, 0, 0, $x, 10)))) }}')],
                            @endfor
                        },
                        opens: 'left',
                        buttonClasses: ['btn btn-default'],
                        applyClass: 'btn-small btn-primary',
                        cancelClass: 'btn-small',
                        format: 'MM/DD/YYYY',
                        separator: ' to ',
                        locale: {
                            applyLabel: '@lang('home.Submit')',
                            fromLabel: '@lang('home.To')',
                            customRangeLabel: '@lang('home.Custom Range')',
                            daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr','Sa'],
                            monthNames: ['@lang('home.January')', '@lang('home.February')', '@lang('home.March')', '@lang('home.April')', '@lang('home.May')', '@lang('home.June')', '@lang('home.July')', '@lang('home.August')', '@lang('home.September')', '@lang('home.October')', '@lang('home.November')', '@lang('home.December')'],
                            firstDay: 1
                        }
                    },
                    function(start, end) {
                        console.log("Callback has been called!");
                        $('#date-filter').parent().find('.from_date').val(start.format('YYYY-MM-DD'));
                        $('#date-filter').parent().find('.to_date').val(end.format('YYYY-MM-DD'));
                        $('#date-filter span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                        datatableTable.draw();
                        $('.month-name').hide();
                    }
                );
                $("#therapist_id").select2({
                    ajax: {
                        url: '{{ URL('admin/sessions/get_therapists') }}',
                        processResults: function (data) {
                            console.log(data)
                            // Transforms the top-level key of the response object from 'items' to 'results'
                            return {
                                results: data.results
                            };
                        },
                    }
                }).on('select2:select',function (e) {
                    selectedData=e.params.data;
                    console.log(selectedData);
                    datatableTable.draw();
                }).on('select2:unselect',function(e){
                    selectedData=e.params.data;
                    console.log(selectedData);
                    datatableTable.draw();
                });
                $(document).on('click','.btn-group label.btn',function(){
                    $(".btn-group label.btn").removeClass('active');
                    $(this).addClass('active');
                });
                $(document).on('change','[name="status"]',function(){
                    datatableTable.draw();
                })
                $(document).on('change','#session_status',function(){
                    datatableTable.draw();
                })
                var datatableTable=$("#datatable-table").DataTable({
                    processing: true,
                    serverSide: false,
                    ajax: {
                        url:"{{ URL('admin/sessions') }}",
                        data:function(data){
                            data.active = $("input[name='status']:checked").val();
                            data.therapist_id=$("#therapist_id").val()
                            var from_date=$("#date-filter").parent().find('.from_date').val();
                            var to_date=$("#date-filter").parent().find('.to_date').val();
                            data.from_date = from_date;
                            data.to_date = to_date;
                            data.session_status=$("#session_status").val();
                            @if(isset($_GET['session_id']))
                                data.session_id='{{ $_GET['session_id'] }}';
                            @endif
                        },
                    },
                    order: [[ 4, 'desc' ]],
                    columns: [
                        {data: 'id', name: 'sessions.id'},
                        // {data: 'therapist.user.name',
                        //     render: function(data, type, row){
                        //         if(row.therapist&&row.therapist.user !=null){
                        //             return row.therapist.user.name
                        //         }else{
                        //             return '';
                        //         }
                        //     },
                        //
                        //     name: 'therapist.user.name'},
                        // {data: 'visitor.user.name',
                        //     render: function(data, type, row){
                        //         if(row.visitor !=null && row.visitor.user !=null ){
                        //             return row.visitor.user.name
                        //         }else{
                        //             return '';
                        //         }
                        //     },
                        //
                        //     name: 'visitor.user.name'},

                        {data: 'therapist_name', name: 'therapist_name'},
                        {data: 'visitor_name', name: 'visitor_name'},
                        {data: 'type', name: 'type'},
                        {data: 'start_time', name: 'start_time'},
                        {data: 'rating', name: 'rating'},
                        {data: 'session_status', name: 'session_status'},

                        {data: 'action', name: 'action', orderable: false, searchable: false},
                    ],
                    dom: 'Bfrtip',
                    buttons: [
                        { extend: 'print', className: 'btn dark btn-outline' },
                        { extend: 'pdf', className: 'btn green btn-outline' },
                        { extend: 'csv', className: 'btn purple btn-outline ' }
                    ],
                });
                @if(PerUser('sessions_active'))

                $(document).on('change','.changeStatues',function(){
                    var statues=$(this).is(':checked');
                    var id=$(this).attr('data-id');


                    if(statues){

                        $.ajax({
                            type: "POST",
                            url: "{{ URL('admin/sessions/activation') }}",
                            data: {"active": 1, "id": id,_token:token},
                            success: function (msg) {
                                $("#errors").html(msg);
                            }
                        });
                    }else{

                        $.ajax({
                            type: "POST",
                            url: "{{ URL('admin/sessions/activation') }}",
                            data: {"active": 0, "id": id,_token:token},
                            success: function (msg) {
                                $("#errors").html(msg);
                            }
                        });
                    }
                });
                @endif
                @if(PerUser('sessions_delete'))
                $(document).on('click','.delete_this',function(event){
                    deleted_id=$(this).attr("data-id");
                    event.preventDefault();
                    BootstrapDialog.show({
                        title: '{{ Lang::get('main.delete').lang::get('main.sessions') }}',
                        message: '{{ Lang::get('main.delete_this').lang::get('main.sessions') }} ?',
                        buttons: [
                            {
                                label: '{{ Lang::get('main.yes') }}',
                                cssClass: 'btn-primary',
                                action: function(dialogItself){
                                    $.ajax({
                                        type: "DELETE",
                                        url: "{{ URL('admin/sessions') }}/"+deleted_id,
                                        data: {"id":deleted_id,_token:token},
                                        success: function (msg) {
                                            $("#errors").html(msg);
                                            $("#sessions-"+deleted_id).remove();
                                            dialogItself.close();
                                        }
                                    });
                                }
                            },
                            {
                                label: '{{ Lang::get('main.no') }}',
                                action: function(dialogItself){
                                    dialogItself.close();
                                }
                            }]
                    });
                });
                @endif
            });
        </script>
    @endif
@endsection
