@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.settings') }}</span>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.app_settings') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.app_settings') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        ul li{
            list-style: none;
        }
        ul li ol{
            margin-top: 10px;
        }
    </style>

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.app_settings') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/app_settings','id'=>'addapp_settingsForm','class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    @foreach($appSettings as $appSetting)
                    <div class="form-group">
                        <label for="app_setting_{{ $appSetting->id }}">{{ $appSetting->name }} <span style="color: red">({{ $appSetting->description }})</span></label>
                        <input type="text" class="form-control" id="app_setting_{{ $appSetting->id }}" name="app_settings[{{ $appSetting->id }}]" value="{{ $appSetting->value }}">
                    </div>
                    @endforeach
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('click',".colors",function(){
                styleURl=$(this).data('url');
                $('.colors').css({'border':'0px','border-color':'none'});
                $(this).css({ 'border':'2px solid','border-color':'#ff0000' });
                $("#style_color").attr('href',styleURl);
            });

            $("#backend_layout").change(function(){
                val=$(this).val();
                footerOption=$("#backend_footer").val();
                if (val === "boxed") {
                    $("body").addClass("page-boxed");
                    // set header
                    $('.page-header > .page-header-inner').addClass("container");
                    var cont = $('body > .clearfix').after('<div class="container"></div>');
                    // set content
                    $('.page-container').appendTo('body > .container');
                    // set footer
                    if (footerOption === 'fixed') {
                        $('.page-footer').html('<div class="container">' + $('.page-footer').html() + '</div>');
                    } else {
                        $('.page-footer').appendTo('body > .container');
                    }
                }else{
                    $("body").removeClass("page-boxed");
                    $('.page-header > .page-header-inner').removeClass("container");
                    var cont = $('body > .clearfix').after('<div class="container"></div>');
                    // set content
                    $('body > .container .page-container').remove;
                    // set footer
                    if (footerOption === 'fixed') {
                        $('.page-footer').html('<div class="container">' + $('.page-footer').html() + '</div>');
                    } else {
                        $('.page-footer').appendTo('body > .container');
                    }
                }
            });
            $("#backend_header").change(function(){
                headerOption=$(this).val();
                if (headerOption === 'fixed') {
                    $("body").addClass("page-header-fixed");
                    $(".page-header").removeClass("navbar-static-top").addClass("navbar-fixed-top");
                } else {
                    $("body").removeClass("page-header-fixed");
                    $(".page-header").removeClass("navbar-fixed-top").addClass("navbar-static-top");
                }
            });
            $("#backend_top_menu_dropdown").change(function(){
                headerTopDropdownStyle=$(this).val();
                if (headerTopDropdownStyle === 'dark') {
                    $(".top-menu > .navbar-nav > li.dropdown").addClass("dropdown-dark");
                } else {
                    $(".top-menu > .navbar-nav > li.dropdown").removeClass("dropdown-dark");
                }
            });



            $("#backend_sidebar_menu_mode").change(function(){
                sidebarOption=$(this).val();
                headerOption=$('#backend_header').val();
                if (sidebarOption == "fixed" && headerOption == "default") {
                    alert('Default Header with Fixed Sidebar option is not supported. Proceed with Fixed Header with Fixed Sidebar.');
                    $('#backend_header').val("fixed");
                    $('#backend_sidebar_menu_mode').val("fixed");
                    sidebarOption = 'fixed';
                    headerOption = 'fixed';
                }
            });
            /*$("#backend_sidebar_menu_sub_show").change(function(){
                sidebarMenuOption=$(this).val();
                sidebarOption=$("#backend_sidebar_menu_mode").val();
                if (sidebarMenuOption === 'hover') {
                    if (sidebarOption == 'fixed') {
                        alert("Hover Sidebar Menu is not compatible with Fixed Sidebar Mode. Select Default Sidebar Mode Instead.");
                    } else {
                        $(".page-sidebar-menu").addClass("page-sidebar-menu-hover-submenu");
                    }
                } else {
                    $(".page-sidebar-menu").removeClass("page-sidebar-menu-hover-submenu");
                }
            });*/

             /*$("#backend_sidebar_menu_sub_show").change(function(){
             $(".top-menu > .navbar-nav > li.dropdown").toggleClass("dropdown-dark");
             });*/
            $("#backend_sidebar_menu_style").change(function(){
                $(".page-sidebar-menu").toggleClass("page-sidebar-menu-light");
            });
            $("#backend_sidebar_menu_position").change(function(){
                $("body").toggleClass('page-sidebar-reversed');
            });
            $("#backend_footer").change(function(){
                $("body").toggleClass('page-footer-fixed');
            });




        });
    </script>
@endsection
