@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/sliders') }}">{{ Lang::get('main.sliders') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.sliders') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-sliders font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.sliders') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/sliders','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
{{--                    <ul class="nav nav-tabs tab-coupon" id="myTab" role="tablist">--}}
{{--                        @foreach($languages as $key=>$language)--}}
{{--                            <li class="nav-item @if($key==0)active @endif"><a class="nav-link" id="{{$language->name}}-tab" data-toggle="tab" href="#{{$language->name}}" role="tab" aria-controls="{{$language->name}}" aria-selected="true" data-original-title="" title="">{{$language->name}} <span ><img style="width: 40px;" src="{{asset($language->flag)}}"></span></a></li>--}}
{{--                        @endforeach--}}
{{--                    </ul>--}}
{{--                    <div class="tab-content" id="myTabContent">--}}
{{--                        @foreach($languages as $key=>$language)--}}
{{--                            @if($key!=0)--}}
{{--                                <input name="languages[]" type="hidden" value="{{$language->id}}">--}}
{{--                            @endif--}}
{{--                            <div class="tab-pane fade @if($key==0) active in @endif" id="{{$language->name}}" role="tabpanel" aria-labelledby="{{$language->name}}-tab">--}}
{{--                                <div class="col-sm-12">--}}
{{--                                    <div class="form-group" style="padding-top: 10px;">--}}
{{--                                        <input class="form-control" @if($key==0) name="title" @else name="titles[]" @endif type="text" placeholder="Title">--}}
{{--                                    </div>--}}
{{--                                    <div class="form-group">--}}
{{--                                        <label style="min-width: 100px">Description </label>--}}
{{--                                        <textarea class="form-control ckeditor" @if($key==0) name="description" @else name="descriptions[]" @endif placeholder="Description" rows="4" cols="80"></textarea>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        @endforeach--}}
{{--                    </div>--}}
                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <label style="min-width: 100px">Title Arabic </label>
                        <input class="form-control" name="title_ar" type="text" placeholder="Title" >
                    </div>
                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <label style="min-width: 100px">Title English </label>
                        <input class="form-control" name="title_en" type="text" placeholder="Title" >
                    </div>
                    <div class="form-group col-lg-12">
                        <label style="min-width: 100px">Description Arabic </label>
                        <textarea class="form-control ckeditor" name="description_ar" placeholder="Description" rows="4" cols="80"></textarea>
                    </div>
                    <div class="form-group col-lg-12">
                        <label style="min-width: 100px">Description English </label>
                        <textarea class="form-control ckeditor" name="description_en" placeholder="Description" rows="4" cols="80"></textarea>
                    </div>
                    <div class="form-group col-lg-12 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="active" value="1" checked data-size="small" data-on-color="success" data-on-text="active" data-off-color="default" data-off-text="unActive">
                    </div>
                    <div class="text-center">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px; border: none"></div>
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                            <div >
                                <span class="btn default btn-file">
                                    <span class="fileinput-new"> {{ Lang::get('main.select_image') }} </span>
                                    <span class="fileinput-exists"> {{ Lang::get('main.change') }} </span>
                                    <input type="file" name="picture"> </span>
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> {{ Lang::get('main.remove') }} </a>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
               if($(this).is(':checked')){
                   $("#projects_ids").attr('disabled','disabled');
               }else{
                   $("#projects_ids").removeAttr('disabled')
               }
            });
        });
    </script>
    @endsection
