{{--{{ print_r(json_decode($static_page->custom_views_projects)).dd() }}--}}
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/static_pages') }}">{{ Lang::get('main.static_pages') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $static_page->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.static_pages') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
    @section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-static_pages font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.static_pages') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/static_pages/'.$static_page->id,'class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="title_ar" type="text" placeholder="Title Arabic" value="{{$static_page->title_ar}}">
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="title_en" type="text" placeholder="Title English" value="{{$static_page->title_en}}">
                    </div>

                    <div class="form-group col-lg-12">
                        <label style="min-width: 100px">Body Arabic </label>
                        <textarea class="form-control ckeditor" name="body_ar" placeholder="Body Arabic" rows="4" cols="80">{{$static_page->body_ar}}</textarea>
                    </div>


                    <div class="form-group col-lg-12">
                        <label style="min-width: 100px">Body English</label>
                        <textarea class="form-control ckeditor" name="body_en" placeholder="Body English" rows="4" cols="80">{{$static_page->body_en}}</textarea>
                    </div>


                    <div class="col-md-12 form-group" style="margin-top:25px;">
                        <input class="form-control" name="url_ar" id="url_ar" placeholder="Page Url Arabic" value="{{$static_page->url_ar}}">
                    </div>


                    <div class="col-md-12 form-group" style="margin-top:25px;">
                        <input class="form-control" name="url_en" id="url_en" placeholder="Page Url English" value="{{$static_page->url_en}}">
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="meta_title_ar" type="text" placeholder="Meta Title Arabic " value="{{$static_page->meta_title_ar}}">
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="meta_title_en" type="text" placeholder="Meta Title English" value="{{$static_page->meta_title_en}}">
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="meta_descripetion_ar" type="text" placeholder="Meta descripetion Arabic" value="{{$static_page->meta_descripetion_ar}}">
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="meta_descripetion_en" type="text" placeholder="Meta descripetion English " value="{{$static_page->meta_descripetion_en}}">
                    </div>

                    <div class="form-group col-lg-12" style="padding-top: 10px;">
                        <input class="form-control" name="meta_keywords" type="text" placeholder="Meta keywords" value="{{$static_page->meta_keywords}}">
                    </div>



                    <div class="form-group col-lg-12 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="active" value="1" @if($static_page->active==1) checked @endif data-size="small" data-on-color="success" data-on-text="active" data-off-color="default" data-off-text="unActive">
                    </div>

                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
                if($(this).is(':checked')){
                    $("#projects_ids").attr('disabled','disabled');
                }else{
                    $("#projects_ids").removeAttr('disabled')
                }
            });
        });
    </script>
@endsection
