{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/system_users') }}">{{ Lang::get('main.system_users') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $post->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.system_users') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
    @section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-system_users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.system_users') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            @if($post->type=='therapists'&&!\App\Therapist::where('user_id',$post->id)->count())
                <a target="_blank" class="btn btn-success pull-right" href="{{ route('sendEmailTherapist',['email'=>$post->email,'verifyToken'=>$post->verifyToken]) }}">verified Link</a>
            @endif
            <div class="portlet-body">

                {!! Form::open(['method'=>'PUT','url'=>'admin/system_users/'.$post->id,'id'=>'addsystem_usersEditForm','class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="type">{{ Lang::get('main.type') }}</label>
                        <select id="type" class="form-control" name="type">
                            <option  value="visitors" @if($post->type=='visitors') selected @endif>visitors</option>
                            <option  value="therapists" @if($post->type=='therapists') selected @endif>therapists</option>
                        </select>
                    </div>

                    <div class="form-group col-lg-9">
                        <label class="control-label" for="name">{{ Lang::get('main.name') }}  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{{ $post->name }}" id="name" name="name" data-required="1" placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                        </div>

                    </div>
                    <div class="clearfix"></div>
                    <div class="form-group col-lg-12">
                        <label class=" control-label" for="website">{{ Lang::get('main.email') }}  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="email" class="form-control" id="email" value="{{ $post->email }}" name="email" data-required="1" placeholder="{{ Lang::get('main.enter').Lang::get('main.email') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="password">{{ Lang::get('main.password') }}  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="password" class="form-control" id="password" name="password" data-required="1" placeholder="{{ Lang::get('main.enter').Lang::get('main.password') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="confirm_password">{{ Lang::get('main.confirm_password') }}  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" data-required="1" placeholder="{{ Lang::get('main.enter').Lang::get('main.confirm_password') }}">
                        </div>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
