@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.system_users') }}</span>
            </li>
        </ul>
        <!--<div class="page-toolbar">
            <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                <i class="icon-calendar"></i>&nbsp;
                <span class="thin uppercase hidden-xs"></span>&nbsp;
                <i class="fa fa-angle-down"></i>
            </div>
        </div>-->
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.system_users') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
@section('content')

    @if(PerUser('system_users_add'))
    <div class="row">
        <div class="col-md-12">
            <div class="btn-group pull-right">
                <a href="{{ URL('admin/system_users/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                    <i class="fa fa-plus"></i>
                </a>
            </div>
        </div>
    </div>
    @endif
    @if(PerUser('system_users_view'))
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-system_users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.system_users') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="sample_1">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">{{ Lang::get('main.name') }}</th>
                        <th class="all">{{ Lang::get('main.type') }}</th>
                        <th class="all">{{ Lang::get('main.email') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $x=1;?>
                    @foreach($system_users as $post)
                        <tr id="system_users-{{ $post->id }}">
                            <td>{{ $x }}</td>
                            <td>{{ $post->name }}</td>
                            <td>{{ $post->type }}</td>
                            <td>{{ $post->email }}</td>
                            <td>
                                <div class="btn-group pull-right">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">{{ Lang::get('main.action') }}
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                        @if(PerUser('system_users_edit'))
                                        <li>
                                            <a href="{{ URL('admin/system_users/'.$post->id.'/edit') }}">
                                                <i class="fa fa-pencil"></i> {{ Lang::get('main.edit') }} </a>
                                        </li>
                                        @endif
                                        @if(PerUser('system_users_delete'))
                                        <li>
                                            <a href="javascript:;" class="delete_this" data-id="{{ $post->id }}">
                                                <i class="fa fa-trash-o"></i> {{ Lang::get('main.delete') }} </a>
                                        </li>
                                        @endif
                                        @if( !empty(\App\Therapist::where('user_id',$post->id)->first()) || $post->type == "visitors" )
                                                <li>
                                                    <a href="{{ URL('admin/system_users/'.$post->id.'/view') }}">
                                                        <i class="fa fa-pencil"></i> {{ Lang::get('main.view-as') }} </a>
                                                </li>
                                        @endif
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php $x++;?>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif
@endsection
@section('scriptCode')
    @if(PerUser('system_users_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            @if(PerUser('system_users_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.system_users') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.system_users') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/system_users') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#system_users-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
