{{--{{ print_r(json_decode($therapist->custom_views_projects)).dd() }}--}}
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/therapists') }}">{{ Lang::get('main.therapists') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $therapist->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.therapists') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @endsection
    @section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.therapists') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/therapists/'.$therapist->id,'files'=>true,'id'=>'therapistsEdit']) !!}

                {{ csrf_field() }}


                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group col-lg-4" style="padding-top: 10px;">
                            <label for="username">User Name</label>
                            <input class="form-control" id="username" name="username" id="username" type="text" placeholder="User Name" value="{{!empty($therapist->user) ? $therapist->user->name : '' }}">
                            <label for="error-username"></label>
                        </div>

                        <div class="form-group col-lg-4" style="padding-top: 10px;">
                            <label for="name_a">Name Ar</label>
                            <input class="form-control" id="name_a" name="name_a" type="text" placeholder="Name Ar" value="{{ old('name_a')?old('name_a'):$therapist->name_a}}">
                            <label for="error-name_a"></label>
                        </div>
                        <div class="form-group col-lg-4" style="padding-top: 10px;">
                            <label for="name_e">Name En</label>
                            <input class="form-control" id="name_e" name="name_e" type="text" placeholder="Name En" value="{{old('name_e')?old('name_e'):$therapist->name_e}}">
                            <label for="error-name_e"></label>
                        </div>
                        <div class="form-group col-lg-12" style="padding-top: 10px;">
                            <label for="license_no">Mobile</label>
                            <input class="form-control" id="mobile" name="mobile" type="text" placeholder="Mobile" value="{{old('mobile')?old('mobile'):$therapist->mobile}}">
                            <label for="error-mobile"></label>
                        </div>
                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="license_no">License no</label>
                            <input class="form-control" id="license_no" name="license_no" type="text" placeholder="License no" value="{{old('license_no')?old('license_no'):$therapist->license_no}}">
                            <label for="error-license_no"></label>
                        </div>
                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="license_org">License org</label>
                            <input class="form-control" id="license_org" name="license_org" type="text" placeholder="License org" value="{{old('license_org')?old('license_org'):$therapist->license_org}}">
                            <label for="error-license_org"></label>
                        </div>

                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="main_specialty_ar">Main specialty Arabic</label>
                            <input class="form-control" id="main_specialty_ar"  name="main_specialty_ar" type="text" placeholder="Main specialty Arabic" value="{{old('main_specialty_ar')?old('main_specialty_ar'):$therapist->main_specialty_ar}}">
                            <label for="error-main_specialty_ar"></label>
                        </div>

                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="main_specialty_en">Main specialty Arabic</label>
                            <input class="form-control" id="main_specialty_en"  name="main_specialty_en" type="text" placeholder="Main specialty Arabic" value="{{old('main_specialty_en')?old('main_specialty_en'):$therapist->main_specialty_en}}">
                            <label for="error-main_specialty_en"></label>
                        </div>


                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="price30">Price 30</label>
                            <input class="form-control" id="price30" name="price30"  type="text" placeholder="Price 30" value="{{old('price30')?old('price30'):$therapist->price30}}">
                            <label for="error-price30"></label>
                        </div>
                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="price60">Price 60</label>
                            <input class="form-control" id="price60" name="price60"  type="text" placeholder="Price 60" value="{{old('price60')?old('price60'):$therapist->price60}}">
                            <label for="error-price60"></label>
                        </div>

                        <!-- price per dollar -->
                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="thirty_price_dollar">Price 30 Dollar</label>
                            <input class="form-control" id="thirty_price_dollar" name="thirty_price_dollar"  type="text" placeholder="Price 30 Dollar" value="{{old('thirty_price_dollar')?old('thirty_price_dollar'):$therapist->thirty_price_dollar}}">
                            <label for="error-thirty_price_dollar"></label>
                        </div>

                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="sixty_price_dollar">Price 60 Dollar</label>
                            <input class="form-control" id="sixty_price_dollar" name="sixty_price_dollar"  type="text" placeholder="Price 60 Dollar" value="{{old('sixty_price_dollar')?old('sixty_price_dollar'):$therapist->sixty_price_dollar}}">
                            <label for="error-sixty_price_dollar"></label>
                        </div>

                        <div class="form-group col-lg-12" style="padding-top: 10px;">
                            <label for="birth">Register Date</label>
                            <input class="form-control" disabled="disabled" id="register_date" name="register_date"  type="text" value="{{$therapist->created_at}}">
                            <label for="error-birth"></label>
                        </div>
                       {{-- <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="birth">Birth date</label>
                            <input class="form-control datepicker" id="birth" name="birth"  type="text" placeholder="Birth date" value="{{old('birth')?old('birth'):$therapist->birth}}">
                            <label for="error-birth"></label>
                        </div>
                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="birth">Register Date</label>
                            <input class="form-control disabled" id="register_date" name="register_date"  type="text" value="{{$therapist->created_at}}">
                            <label for="error-birth"></label>
                        </div>--}}

                        <div class="col-md-12 form-group"  style="padding-top: 10px;">
                            <label for="main_focus">Main focus</label>
                            @php $ids=\App\TherapistsMainFocus::where('therapist_id',$therapist->id)->pluck('main_focus_id')->toArray(); @endphp
                            <select class="form-control select2" name="main_focus[]" multiple id="main_focus">
                                @foreach(\App\MainFocus::active()->pluck('title_ar','id')->toArray() as $id=>$name)
                                    <option @if(in_array($name, explode(',', $therapist->main_focus))) selected @endif value="{{ $name }}">{{ $name }}</option>
                                @endforeach
                            </select>
                            <label for="error-main_focus"></label>
                        </div>
                        {{--<div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="main_focus_ar">Main Focus Arabic</label>
                            <input class="form-control" id="main_focus_ar" name="main_focus_ar"  type="text" placeholder="Main Focus Arabic"  value="{{old('main_focus_ar')?old('main_focus_ar'):$therapist->main_focus_ar}}">
                            <label for="error-main_focus_ar"></label>
                        </div>

                        <div class="form-group col-lg-6" style="padding-top: 10px;">
                            <label for="main_focus_en">Main Focus English</label>
                            <input class="form-control" id="main_focus_en" name="main_focus_en"  type="text" placeholder="Main Focus English"  value="{{old('main_focus_en')?old('main_focus_en'):$therapist->main_focus_en}}">
                            <label for="error-main_focus_en"></label>
                        </div>--}}

                        <div class="form-group col-12">
                            <label style="min-width: 100px">Description Arabic </label>
                            <textarea class="form-control ckeditor" id="description_ar" name="description_ar" placeholder="Description Arabic" rows="4" cols="80"> {{old('description_ar')?old('description_ar'):$therapist->description_ar}} </textarea>
                            <label for="error-description_ar"></label>
                        </div>

                        <div class="form-group col-12">
                            <label style="min-width: 100px">Description English </label>
                            <textarea class="form-control ckeditor" id="description_en" name="description_en" placeholder="Description English" rows="4" cols="80">{{old('description_en')?old('description_en'):$therapist->description_en}}</textarea>
                            <label for="error-description_en"></label>
                        </div>

                        <div class="form-group col-12">
                            <label style="min-width: 100px">Summary Arabic </label>
                            <textarea class="form-control ckeditor" id="summery_ar" name="summery_ar" placeholder="Summary Arabic" rows="4" cols="80"> {{old('summery_ar')?old('summery_ar'):$therapist->summery_ar}} </textarea>
                            <label for="error-summery_ar"></label>
                        </div>

                        <div class="form-group col-12">
                            <label style="min-width: 100px">Summary English </label>
                            <textarea class="form-control ckeditor" id="summery_en" name="summery_en" placeholder="Summary English" rows="4" cols="80">  {{old('summery_en')?old('summery_en'):$therapist->summery_en}} </textarea>
                            <label for="error-summery_en"></label>
                        </div>

                    </div>
                    <div class="col-md-6 form-group"  style="padding-top: 10px;">
                        <label for="gender">Gender </label>
                        <select id="gender" name="gender" class="form-control" >
                            <option value="">Select Gender</option>
                            <option value="male" @if((old('gender')&&old('gender')=='male')||(!old('gender')&&$therapist->gender=='male')) selected @endif>Male</option>
                            <option value="female" @if((old('gender')&&old('gender')=='female')||(!old('gender')&&$therapist->gender=='female')) selected @endif>Female</option>
                        </select>
                        <label for="error-gender"></label>
                    </div>
                    <div class="col-md-6 form-group"  style="padding-top: 10px;">
                        <label for="user_id">User</label>
                        <select id="user_id" name="user_id" class="form-control" disabled>
                            @foreach($users as $id=>$title)
                                <option value="{{$id}}" @if((old('user_id')&&old('user_id')==$id)||(!old('user_id')&&$therapist->user_id==$id)) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                        <label for="error-user_id"></label>
                    </div>
                    <div class="col-md-6 form-group">
                        <label for="country_id">Country</label>
                        <select id="country_id" name="country_id" class="form-control">
                            @foreach($countries as $id=>$title)
                                <option value="{{$id}}" @if((old('country_id')&&old('country_id')==$id)||(!old('country_id')&&$therapist->country_id==$id)) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                        <label for="error-country_id"></label>
                    </div>

                    <div class="col-md-6 form-group">
                        <label for="language_id">Languages </label>
                        <select id="language_id" name="language_id" class="form-control" >
                            @foreach($languages as $id=>$title)
                                <option value="{{$id}}" @if((old('language_id')&&old('language_id')==$id)||(!old('language_id')&&$therapist->language_id==$id)) selected @endif> {{ $title }} </option>
                            @endforeach
                        </select>
                        <label for="error-language_id"></label>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="certificates">Certificates Arabic </label>
                        <textarea class="form-control ckeditor" id="certifications_ar" name="certifications_ar" placeholder="Certificates Arabic" rows="4" cols="80">{{old('summery_en')?old('summery_en'):$therapist->certifications_ar  }}</textarea>
                        <label for="error-certifications_ar"></label>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="certificates">Certificates English </label>
                        <textarea class="form-control ckeditor" id="certifications_en" name="certifications_en" placeholder="Certificates English" rows="4" cols="80">{{ old('certifications_en')?old('certifications_en'):$therapist->certifications_en  }}</textarea>
                        <label for="error-certifications_en"></label>
                    </div>


                    <div class="col-md-12 form-group">
                        <label for="experiences">Experience Arabic </label>
                        <textarea class="form-control ckeditor" id="experience_ar" name="experience_ar" placeholder="Certificates Arabic" rows="4" cols="80">{{ old('experience_ar')?old('experience_ar'):$therapist->experience_ar }}</textarea>
                        <label for="error-experience_ar"></label>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="experiences">Experience English </label>
                        <textarea class="form-control ckeditor" id="experience_en" name="experience_en" placeholder="Certificates English" rows="4" cols="80">{{ old('experience_en')?old('experience_en'):$therapist->experience_en }}</textarea>
                        <label for="error-experience_en"></label>
                    </div>


                    <div class="col-md-12 form-group">
                        <label for="country_id">Specialties</label>
                        <select id="specialties" name="specialties[]" class="form-control select2" multiple>
                            @foreach($specialties as $id=>$title)
                                <option value="{{$id}}" @if(in_array($id,$therapist_specialties)) selected @endif>{{$title}}</option>
                            @endforeach
                        </select>
                        <label for="error-specialties"></label>
                    </div>


                    <div class="col-md-12 form-group">
                        <label for="experiences">Rating </label><br>
                        <input type="radio" @if($therapist->rating == 1) checked @endif  name="rating" value="1"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i></span><br>
                        <input type="radio" @if($therapist->rating == 2) checked @endif name="rating" value="2"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                        <input type="radio" @if($therapist->rating == 3) checked @endif name="rating" value="3"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                        <input type="radio" @if($therapist->rating == 4) checked @endif name="rating" value="4"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>
                        <input type="radio" @if($therapist->rating == 5) checked @endif name="rating" value="5"><span style="margin: 10px;    color: #ffb42a;"><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i></span><br>

                    </div>

                    <br>

                    <div class="form-group col-lg-7" style="padding-top: 10px;">
                        <label for="birth">Money PAID In EGP</label>
                        <input class="form-control"  name="money_paid_egp"  type="number" min="0" value="{{$therapist->money_paid_egp}}">
                        <label for="error-money_paid_egp"></label>
                    </div>
                    <div class="form-group col-lg-7" style="padding-top: 10px;">
                        <label for="birth">Money PAID In USD</label>
                        <input class="form-control"  name="money_paid_usd"  type="number" min="0" value="{{$therapist->money_paid_usd}}">
                        <label for="error-money_paid_usd"></label>
                    </div>

                    <br>



                    <div class="col-md-12 form-group">
                        <div class="col-md-4">
                            <label for="cv"> Cv </label>
                            <div class="formelement">
                                <a href="{{ url('admin/download-resume/'.$therapist->id)  }}" class="btn btn-info btn-sm">
                                    {{ trans('home.download-resume')  }} </a>
                            </div>

                        </div>
                        <div class="col-md-4 col-md-offset-1">
                            <label for="cv">Licence </label>
                            <div class="formelement">
                                <a href="{{ url('admin/download-licence/'.$therapist->id)  }}" class="btn btn-info btn-sm">
                                    {{ trans('home.download-licence')  }} </a>
                            </div>

                        </div>
                        <div class="col-md-2">
                            <label for="cv">Certificates </label>
                            <div class="formelement">
                                <a href="{{ url('admin/download-certificate/'.$therapist->id)  }}" class="btn btn-info btn-sm">
                                    {{ trans('home.download-certificate')  }} </a>
                            </div>

                        </div>

                    </div>

                    <div class="col-md-12 form-group">
                        @if ($therapistimages->count() > 0)
                        <table class="table table-bordered">
                            <thead>
                              <tr>
                                <th scope="col">#</th>
                                <th scope="col">image</th>
                                <th scope="col">choose picture</th>

                              </tr>
                            </thead>
                            <tbody>
                                @foreach ($therapistimages as $index=>$therapistimage)
                              <tr>
                                <th scope="row">{{ $index + 1 }}</th>
                                <input type="hidden" id="urlid" value="{{$therapist->id}}">

                                <td>

                                    <img  src="{{ asset('avatars/therapists/'.$therapistimage->pictures) }}" style="width: 100px"  class="img-thumbnail" alt="">

                                </td>
                                <td>
                                    <div class="form-check">
                                            @if($therapist->picture == $therapistimage->pictures)
                                        <input onclick="saveimage('{{$therapistimage->pictures}}')" checked  class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault{{$therapist->id}}">
                                        <label class="form-check-label" for="flexRadioDefault1">
                                          @else
                                          <input onclick="saveimage('{{$therapistimage->pictures}}')"   class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault{{$therapist->id}}">
                                        <label class="form-check-label" for="flexRadioDefault1">
                                            @endif
                                        </label>
                                      </div>
                                </td>

                              </tr>
                              @endforeach
                            </tbody>
                          </table>


                    @endif
                    </div>

                    <div class="form-group col-lg-12 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" id="active" name="active" value="1" @if((old('active')&&old('active')==1)||(!old('active')&&$therapist->active==1)) checked @endif data-size="small" data-on-color="success" data-on-text="active" data-off-color="default" data-off-text="unActive">
                    </div>
{{--                    <div class="form-group col-lg-12">--}}
{{--                        <div class="custom-file">--}}
{{--                            <input type="file" name="resume" class="custom-file-input" id="customFile">--}}
{{--                            <label class="custom-file-label"  for="customFile">Upload Resume</label>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                    <div class="text-center">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px; border: none">
                                <img src="{{ asset('avatars/therapists/'.$therapist->picture) }}" alt="" /> </div>
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                            <div >
                                <span class="btn default btn-file">
                                    <span class="fileinput-new"> {{ Lang::get('main.select_image') }} </span>
                                    <span class="fileinput-exists"> {{ Lang::get('main.change') }} </span>
                                    <input type="file" id="picture" name="picture"> </span>
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> {{ Lang::get('main.remove') }} </a>
                            </div>
                            <label for="error-picture"></label>
                        </div>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>

                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function(){
            var therapistStatus={{ $therapist->active?'true':'false' }}

            $("#therapistsEdit").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                rules : {
                    name_a:{
                        required:function (element) {
                            return $("#active").is(':checked');
                            return ($("#active").is(':checked')&&!therapistStatus)?true:false;
                        },
                    },
                    name_e : {
                        required:function (element) {
                            return $("#active").is(':checked');
                            return ($("#active").is(':checked')&&!therapistStatus)?true:false;
                        },
                    },
                    gender:{
                        required:function (element) {
                            return $("#active").is(':checked');
                            return ($("#active").is('checked')&&!therapistStatus)?true:false;
                        },
                    },
                    price30:{
                        required:function (element) {
                            return $("#active").is(':checked');
                            return ($("#active").is(':checked')&&!therapistStatus)?true:false;
                        },
                    },
                    price60:{
                        required:function (element) {
                            return $("#active").is(':checked');
                            return ($("#active").is(':checked')&&!therapistStatus)?true:false;
                        },
                    },
                    @if(!$therapist->picture)
                    picture:{
                        required:function (element) {
                            return $("#active").is(':checked');
                            return ($("#active").is(':checked')&&!therapistStatus)?true:false;
                        },
                    },
                    @endif
                },
                messages: {
                    name_a:{
                        required:"@lang('home.required_field')",
                    },
                    name_e : {
                        required:"@lang('home.required_field')",
                    },
                    gender:{
                        required:"@lang('home.required_field')",
                    },
                    price30:{
                        required:"@lang('home.required_field')",
                    },
                    price60:{
                        required:"@lang('home.required_field')",
                    },
                    @if(!$therapist->picture)
                    picture:{
                        required:"@lang('home.required_field')",
                    },
                    @endif
                },
            });


            $( ".datepicker" ).datepicker({dateFormat: "dd-mm-yyyy"});
            $('.select2').select2();
            $(document).on('change','#all_projects',function(){
                if($(this).is(':checked')){
                    $("#projects_ids").attr('disabled','disabled');
                }else{
                    $("#projects_ids").removeAttr('disabled')
                }
            });
        });
    </script>


<script>


    function saveimage(picture) {
        var id=$('#urlid').val(),
        token= '{{ csrf_token() }}';

        $.ajax({
                url:'{{URL::to("therapistspic")}}',
                type:'GET',
                data:{"id": id, "picture": picture,_token:token},
                success: function(response) {

                    window.location.reload();


            },

        });





}
</script>


@endsection
