@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.therapists') }}</span>
                </div>
                <a href="{{ URL('admin/therapists/export') }}" id="sample_editable_1_new" class="btn green"> Export data
                    <i class="fa fa-file-export"></i>
                </a>
                @if(PerUser('therapists_add'))
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/therapists/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                @endif
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('therapists_view'))
                    <div class="btn-group" role="group">
                        <input type="radio" class="btn-check hidden" name="status" id="all" value="all" autocomplete="off" >
                        <label class="btn btn-primary" for="all">All</label>

                        <input type="radio" class="btn-check hidden " name="status" id="active" value="active" autocomplete="off" checked>
                        <label class="btn btn-primary active" for="active">Active</label>

                        <input type="radio" class="btn-check hidden" name="status" id="unactive" value="unactive" autocomplete="off">
                        <label class="btn btn-primary" for="unactive">Un Active</label>


                        <input type="radio" class="btn-check hidden " name="status" id="archive" value="archive" autocomplete="off">
                        <label class="btn btn-primary" for="archive">Archive</label>

                        <input type="radio" class="btn-check hidden" name="status" id="unarchive" value="unarchive" autocomplete="off">
                        <label class="btn btn-primary" for="unarchive">Un archive</label>

                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>
                        <th class="all">{{ Lang::get('main.username') }}</th>
                        <th class="all">{{ Lang::get('main.therapist-name') }}</th>
                        <th class="all">{{ Lang::get('main.image') }}</th>
                        <th cl§ass="all">{{ Lang::get('main.main_specialty_ar') }}</th>
                        <th class="all">{{ Lang::get('main.main_specialty_en') }}</th>
                        <th class="all">{{ Lang::get('main.email') }}</th>
                        <th class="all">{{ Lang::get('main.reset') }}</th>
                        <th class="all">{{ Lang::get('main.active') }}</th>
                        <th class="all">{{ Lang::get('main.archive') }}</th>
                        <th class="all">Resume</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    {{--@foreach($therapists as $therapist)
                        <tr id="therapists-{{ $therapist->id }}">
                            <td>{{ $x }}</td>
                            <td> <a href="{{ URL('admin/system_users/'.$therapist->id.'/edit') }}"> {{ !empty($therapist->user) ? $therapist->user->name : '' }} </a> </td>
                            <td>{{ $therapist->name_a }}</td>
                            <td class="text-center"><img style="height: 100px;width: 100px;" src="{{ asset('avatars/therapists/'.$therapist->picture) }}" alt=""></td>
                            <td>{{ $therapist->main_specialty_ar }}</td>
                            <td>{{ $therapist->main_specialty_en }}</td>
                            <td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="{{ $therapist->id }}" type="checkbox" @if(!PerUser('therapists_active')) disabled="disabled" @endif class="@if(PerUser('therapists_active')) changeStatues @endif"  @if($therapist->active==1) checked="checked" @endif   id="checkbox-{{ $therapist->id }}">
                                    <label for="checkbox-{{ $therapist->id }}">
                                    </label>
                                </div>
                            </td>
                            <td class="text-center">
                                @if(!empty($therapist->resume))
                                    <a target="_blank" href="{{url('resumes/'.$therapist->resume)}}"><i class="fa fa-download"></i></a>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group pull-right">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">{{ Lang::get('main.action') }}
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                        @if(PerUser('therapists_edit'))
                                        <li>
                                            <a href="{{ URL('admin/therapists/'.$therapist->id.'/edit') }}">
                                                <i class="fa fa-pencil"></i> {{ Lang::get('main.edit') }} </a>
                                        </li>
                                        @endif
                                        @if(PerUser('therapists_delete'))
                                        <li>
                                            <a href="javascript:;" class="delete_this" data-id="{{ $therapist->id }}">
                                                <i class="fa fa-trash-o"></i> {{ Lang::get('main.delete') }} </a>
                                        </li>
                                        @endif
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php $x++;?>
                    @endforeach--}}
                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('therapists_view'))
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script>
        $(document).ready(function(){
            $(".menu-toggler.sidebar-toggler").trigger('click');
            token= '{{ csrf_token() }}';
            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/therapists') }}",
                    data:function(data){
                    data.active = $("input[name='status']:checked").val();
                },
            },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'name', name: 'users.name'},
                    {data: 'name_a', name: 'therapists.name_a'},
                    {data: 'picture', name: 'therapists.picture'},
                    {data: 'main_specialty_ar', name: 'therapists.main_specialty_ar'},
                    {data: 'main_specialty_en', name: 'therapists.main_specialty_en'},
                    {data: 'email',
                    name: 'users.email'},
                    {data: 'reset', name: 'reset', searchable: false},
                    {data: 'active', name: 'therapists.active', searchable: false},
                    {data: 'archive', name: 'therapists.archive', searchable: false},
                    {data: 'resume', name: 'therapists.resume', searchable: false},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
                "order": [[ 0, "desc" ]]
            });
            @if(PerUser('therapists_archive'))
            $(document).on('change','.changeArchiveStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');
                if(statues){
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/archive') }}",
                        data: {"archive": 1, "id": id,_token:token},
                        success: function (msg) {
                            datatableTable.draw();
                        }
                    });
                }else{
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/archive') }}",
                        data: {"archive": 0, "id": id,_token:token},
                        success: function (msg) {
                            datatableTable.draw();
                        }
                    });
                }

            });
            @endif

            @if(PerUser('therapists_active'))
            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');
                if(statues){

                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/activation') }}",
                        data: {"active": 1, "id": id,_token:token},
                        success: function (msg) {

                            if(msg !='active'){
                                //alert(msg);
                                swal(msg);

                                $(".changeStatues").prop('checked', false);

                            }
                            $("#errors").html(msg);
                            location.reload();
                        }
                    });
                }else{
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/activation') }}",
                        data: {"active": 0, "id": id,_token:token},
                        success: function (msg) {

                            $("#errors").html(msg);
                            location.reload();
                        }
                    });
                }
            });
            @endif
            @if(PerUser('therapists_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.therapists') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.therapists') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/therapists') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#therapists-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });

        $(document).on('click','.sendEmailAgainss',function(){
            el=$(this);

            el.attr('disabled','disabled').find('.fa-spin').removeClass('hidden');
            user_id=el.attr('data-id');
            $.ajax({
                type: "POST",
                url: "{{ URL('admin/therapists/sendEmail') }}",
                data: {"user_id":user_id,_token:token},
                success: function (msg) {
                    el.removeAttr('disabled').find('.fa-spin').addClass('hidden');
                  //  datatableTable.draw();
                }
            });
        })

        $(document).on('click','.copylinkhh',function(){
            el=$(this);
            el.attr('disabled','disabled').find('.fa-spin').removeClass('hidden');
            user_id=el.attr('data-id');
            $.ajax({
                type: "POST",
                url: "{{ URL('admin/therapists/copyemail') }}",
                data: {"user_id":user_id,_token:token},
                success: function (msg) {
                    copyTextToClipboard(msg);
                    el.removeAttr('disabled').find('.fa-spin').addClass('hidden');

                }
            });
        })

        ///// copy
        function copyTextToClipboard(text) {
            var textArea = document.createElement("textarea");


            textArea.style.position = 'fixed';
            textArea.style.top = 0;
            textArea.style.left = 0;


            textArea.style.width = '2em';
            textArea.style.height = '2em';

            textArea.style.padding = 0;

            textArea.style.border = 'none';
            textArea.style.outline = 'none';
            textArea.style.boxShadow = 'none';


            textArea.style.background = 'transparent';


            textArea.value = text;

            document.body.appendChild(textArea);

            textArea.select();

            try {
                var successful = document.execCommand('copy');
                var msg = successful ? 'successful' : 'unsuccessful';
                console.log('Copying text command was ' + msg);
            } catch (err) {
                console.log('Oops, unable to copy');
            }

            document.body.removeChild(textArea);
        }
    </script>
    @endif
    @endsection
