
<br>
<br>
<br>
@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection

@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.therapistsrequests') }}</span>
                </div>

                <div class="tools"> </div>


            </div>
            <div class="portlet-body">
                @if(PerUser('therapists_view'))

                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">#</th>

                        <th class="all">{{ Lang::get('main.therapist-name') }}</th>
                        <th class="all">{{ Lang::get('main.column-name') }}</th>
                        <th class="all">{{ Lang::get('main.from') }}</th>
                        <th class="all">{{ Lang::get('main.to') }}</th>
                        <th class="all">{{ Lang::get('main.add_date') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('therapists_view'))
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.btn-group label.btn',function(){
                $(".btn-group label.btn").removeClass('active');
                $(this).addClass('active');
            });
            $(document).on('change','[name="status"]',function(){
                datatableTable.draw();
            })
            var url = window.location.pathname;
        var id = url.substring(url.lastIndexOf('/') + 1);

            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:'{{URL::to("admin/therapists_requests_search")}}' + "/" + id,

            },

                columns: [
                    {data: 'id', name: 'id'},

                    {data: 'therapist.name_a', name: 'therapist.name_a'},
                    {data: 'column_name',

                    render: function(data, type, row){

                     if((row.column_name == "speciality_id")){
                         return "{{ Lang::get('main.specialties') }}";
                     }
                     if((row.column_name == "language_id")){
                        return "{{ Lang::get('main.languages') }}";
                     }
                     if((row.column_name == "name_e")){
                        return "{{ Lang::get('main.name_e') }}";
                     }
                     if((row.column_name == "name_a")){
                        return "{{ Lang::get('main.name_a') }}";
                     }
                     if((row.column_name == "summery_ar")){
                        return "{{ Lang::get('main.summery_ar') }}";
                     }
                     if((row.column_name == "summery_en")){
                        return "{{ Lang::get('main.summery_en') }}";
                     }
                     if((row.column_name == "description_ar")){
                        return "{{ Lang::get('main.description_ar') }}";
                     }
                     if((row.column_name == "description_en")){
                        return "{{ Lang::get('main.description_en') }}";
                     }
                     if((row.column_name == "thirty_price_dollar")){
                        return "{{ Lang::get('main.thirty_price_dollar') }}";
                     }
                     if((row.column_name == "sixty_price_dollar")){
                        return "{{ Lang::get('main.sixty_price_dollar') }}";
                     }
                     if((row.column_name == "certifications_ar")){
                        return "{{ Lang::get('main.certifications_ar') }}";
                     }
                     if((row.column_name == "certifications_en")){
                        return "{{ Lang::get('main.certifications_en') }}";
                     }
                     if((row.column_name == "experience_ar")){
                        return "{{ Lang::get('main.experience_ar') }}";
                     }
                     if((row.column_name == "experience_en")){
                        return "{{ Lang::get('main.experience_en') }}";
                     }
                     if((row.column_name == "country_id")){
                        return "{{ Lang::get('main.countries') }}";
                     }
                     if((row.column_name == "price30")){
                        return "{{ Lang::get('main.price30') }}";
                     }
                     if((row.column_name == "price60")){
                        return "{{ Lang::get('main.price60') }}";
                     }
                     if((row.column_name == "license_no")){
                        return "{{ Lang::get('main.license_no') }}";
                     }
                     if((row.column_name == "license_org")){
                        return "{{ Lang::get('main.license_org') }}";
                     }
                     if((row.column_name == "main_specialty_ar")){
                        return "{{ Lang::get('main.main_specialty_ar') }}";
                     }
                     if((row.column_name == "main_specialty_en")){
                        return "{{ Lang::get('main.main_specialty_en') }}";
                     }
                     else{
                         return $.fn.dataTable.render.number( ',', '.', 0 ).display(row.column_name);
                     }


             },

                     name: 'column_name'},

                    //{data: 'therapist.specialties[0].title_en', name: 'therapists_requests.from'},
                    {data: 'from',
                    render: function(data, type, row){

                            if((row.column_name == "speciality_id")){
                                return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.therapist.specialties[0].title_en)
                            }

                            if((row.column_name == "zip_certificates")){
                                return "<a href=\"/certificates/" + row.from + "\" >" + row.from +"</a>"
                            }

                            if((row.column_name == "summery_ar")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }
                            if((row.column_name == "summery_en")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }

                            if((row.column_name == "certifications_ar")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }
                            if((row.column_name == "certifications_en")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }

                            if((row.column_name == "description_ar")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }
                            if((row.column_name == "description_en")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }

                            if((row.column_name == "experience_ar")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }
                            if((row.column_name == "experience_en")){
                                  return jQuery('<p>' + row.from + '</p>').text();
                            }



                            if((row.column_name == "language_id")){
                             if(row.languagefrom !=null){
                                return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.languagefrom.title_en)
                             }else{
                                return row.from;
                             }
                            }

                            if((row.column_name == "country_id")){
                             if(row.countaryfrom !=null){
                                return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.countaryfrom.title_ar)
                             }else{
                                return row.from;
                             }
                            }

                            if((row.column_name == "picture")){
                                if(row.from  !=null){
                                    return "<img src=\"/avatars/therapists/" + row.from + "\" height=\"70\"/>";
                                }else{
                                    return row.from;
                                }

                            }
                            if((row.column_name == "licence")){
                                if(row.from  !=null){
                                    return "<img src=\"/licences/" + row.from + "\" height=\"70\"/>";
                                }else{
                                    return row.from;
                                }

                            }

                            if((row.column_name == "resume")){
                                if(row.from  !=0){
                                return "<embed src=\"/resumes/" + row.from + "\" width='100' height='100' alt='pdf' >";
                                }else{
                                    return row.from;
                                }
                            }


                            else{
                                return row.from;
                            }


                    },


                     name: 'therapists_requests.from'},


                     {data: 'to',
                    render: function(data, type, row){


                            if((row.column_name == "speciality_id")){
                                return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.therapistto.title_en)
                            }
                            if((row.column_name == "language_id")){
                                if(row.languageto !=null){
                                return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.languageto.title_en)
                                }else{
                                    return row.to;
                                }
                            }

                            if((row.column_name == "country_id")){
                                if(row.countaryto !=null){
                                return $.fn.dataTable.render.number( ',', '.', 0, '$' ).display(row.countaryto.title_ar)
                                }else{
                                    return row.to;
                                }
                            }

                            if((row.column_name == "picture")){
                                return "<img src=\"/avatars/therapists/" + row.to + "\" height=\"70\"/>";
                            }
                            if((row.column_name == "licence")){
                                return "<img src=\"/licences/" + row.to + "\" height=\"70\"/>";
                            }
                            if((row.column_name == "resume")){
                                return "<embed src=\"/resumes/" + row.to + "\" width='100' height='100' alt='pdf' >";
                            }



                            if((row.column_name == "summery_ar")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }
                            if((row.column_name == "summery_en")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }

                            if((row.column_name == "certifications_ar")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }
                            if((row.column_name == "certifications_en")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }

                            if((row.column_name == "description_ar")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }
                            if((row.column_name == "description_en")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }

                            if((row.column_name == "experience_ar")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }
                            if((row.column_name == "experience_en")){
                                  return jQuery('<p>' + row.to + '</p>').text();
                            }

                            if((row.column_name == "zip_certificates")){
                                return "<a href=\"/certificates/" + row.to + "\"  target='_blank'> " + row.to +"</a>"
                            }

                            else{

                                return row.to;
                            }
                    },

                     name: 'therapists_requests.to'},

                     {data: 'created_at',
                     render: function(data, type, row,result){

                     var d = new Date(row.created_at);
                      result = d.getFullYear()+"/"+(d.getMonth()+1)+"/"+d.getDate() +
                     " "+ d.getHours()+":"+d.getMinutes()+":"+
                        d.getSeconds()+" "+d.getMilliseconds();
                         return result;

                     }
                     , name: 'created_at'},

                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });


        });



        function approve(id,btn) {

            var url = '{{URL::to("admin/therapistsrequests")}}' + "/" + id+"/edit";
            var menu = $('#menu').val();
            document.getElementById("approve").disabled = true;

            data = {
                id: id,
                _token: "{{csrf_token()}}",
            };
            $.ajax({
                url: url,
                type: 'get',
                dataType: 'json',
                data: data,
                success: function(response) {

                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);

                    swal("Approved successfully!")
                    document.getElementById("approve").disabled = false;


                },
                error: function(response) {
                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);
                    swal("Approved successfully!")
                    document.getElementById("approve").disabled = false;


                }
            });
        }


        function disapprove(id,btn) {
            var url = '{{URL::to("therapists_requests_destoy")}}' + "/" + id;
            var menu = $('#menu').val();

            document.getElementById("disapprove").disabled = true;

            data = {
                id: id,
                _token: "{{csrf_token()}}",
            };
            $.ajax({
                url: url,
                type: 'get',
                dataType: 'json',
                data: data,
                success: function(response) {
                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);
                    swal("disApproved successfully!")
                    document.getElementById("disapprove").disabled = false;

                },
                error: function(response) {
                    var row = btn.parentNode.parentNode;
                    row.parentNode.removeChild(row);
                    swal("disApproved successfully!")
                    document.getElementById("disapprove").disabled = false;


                }
            });
        }
    </script>







    @endif
    @endsection
