@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
@endsection
@section('content')
    <div class="clearfix" style="height: 30px;"></div>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.therapists') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                @if(PerUser('therapists_view'))

                    <div class="pull-left">
                        <a class="btn btn-danger sendSelectedEmailAgain" disabled="disabled" href="javascript:;" title="Send Complete Register Link"><i class="fa fa-circle-o-notch fa-spin hidden"></i>Send Link</a>
                    </div>
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable-table">
                    <thead>
                    <tr>
                        <th class="all">
                            <div class="checkbox-nice checkbox-inline">
                                <input  type="checkbox" class="checkAll">
                            </div
                            ></th>
                        <th class="all">#</th>

                        <th class="all">{{ Lang::get('main.name') }}</th>
                        <th class="all">{{ Lang::get('main.email') }}</th>
                        <th class="all">{{ Lang::get('main.send_register_link_date') }}</th>
                        <th class="all">{{ Lang::get('main.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    @if(PerUser('therapists_view'))
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            function disableSendSelectEmailButton(){
                ids=[];
                $(".therapistsCheckbox:checked").each(function () {
                    ids.push($(this).attr('data-id'));
                });
                if(ids.length){
                    $(".sendSelectedEmailAgain").removeAttr('disabled');
                }else{
                    $(".sendSelectedEmailAgain").attr('disabled','disabled');
                }
            }
            $(document).on('click','.sendSelectedEmailAgain',function(e){
                $(this).attr('disabled','disabled');
                e.preventDefault();
                ids=[];
                $(".therapistsCheckbox:checked").each(function () {
                    ids.push($(this).attr('data-id'));
                });
                if(ids.length){
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/sendEmail') }}",
                        data: {"ids":ids,_token:token},
                        success: function (msg) {
                            datatableTable.draw();
                            $(".checkAll").prop('checked',false);
                        }
                    });
                }

            })
            $(document).on('change','.checkAll',function(){
                $(".therapistsCheckbox").prop('checked',$(this).is(':checked'));
                disableSendSelectEmailButton();
            })
            $(document).on('change','.therapistsCheckbox',function(){
                disableSendSelectEmailButton();
            })
            $(document).on('click','.sendEmailAgain',function(){
                el=$(this);
                el.attr('disabled','disabled').find('.fa-spin').removeClass('hidden');
                user_id=el.attr('data-id');
                $.ajax({
                    type: "POST",
                    url: "{{ URL('admin/therapists/sendEmail') }}",
                    data: {"user_id":user_id,_token:token},
                    success: function (msg) {
                        el.removeAttr('disabled').find('.fa-spin').addClass('hidden');
                        datatableTable.draw();
                    }
                });
            })
            var datatableTable=$("#datatable-table").DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                url:"{{ URL('admin/therapists/not-completed') }}",
                    data:function(data){

                },
            },
                columns: [
                    {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false,class:'text-center'},
                    {data: 'id', name: 'id'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'send_register_link_date', name: 'send_register_link_date'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'print', className: 'btn dark btn-outline' },
                    { extend: 'pdf', className: 'btn green btn-outline' },
                    { extend: 'csv', className: 'btn purple btn-outline ' }
                ],
            });
            @if(PerUser('therapists_active'))
            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');
                if(statues){
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/activation') }}",
                        data: {"active": 1, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/therapists/activation') }}",
                        data: {"active": 0, "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            @if(PerUser('therapists_delete'))
            $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.therapists') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.therapists') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/therapists') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#therapists-"+deleted_id).remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });
    </script>
    @endif
    @endsection
