@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/therapists') }}">{{ Lang::get('main.visitors') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
        </ul>
    </div>

    <h1 class="page-title"> {{ Lang::get('main.visitors') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>

@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-therapists font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.visitors') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/visitors/'.$user->id,'class'=>"form-horizontal",'files'=>true,'id'=>'visitorCreateForm']) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group" style="padding-top: 10px;">
                            <input id="name" class="form-control"  name="name" type="text" placeholder="Name" value="{{ $user->name  }}">
                        </div>
                        <label  class="invalid-feedback" role="alert" for="error-name"></label>

                        <div class="form-group" style="padding-top: 10px;">
                            <input  id="email" class="form-control"  name="email" type="email" placeholder="email" value="{{ $user->email  }}">
                        </div>
                        <label for="error-email"></label>

                        <div class="form-group" style="padding-top: 10px;">
                            <input  id="gender"  class="form-control"  name="gender" type="text" placeholder="gender" value="{{ $user->gender }}">
                        </div>
                        <label for="error-gender"></label>


                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control" id="mobile"  name="mobile" type="text" placeholder="mobile" value="{{ $user->mobile  }}">
                        </div>
                        <label for="error-mobile"></label>


                        <div class="form-group" style="padding-top: 10px;">
                            <input class="form-control"  id="birthyear"  name="birthyear" type="text" placeholder="birth of year" value="{{ $user->birthyear  }}">
                        </div>
                        <label for="error-birthyear"></label>

                    </div>

                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.update') }}</button>
                    </div>
                </div>
                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

@endsection
@section('scriptCode')
    <script type="text/javascript">

        //author:mohammed.khalf@almoasherbiz.com
        jQuery.validator.addMethod("noSpace", function(value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "No space please and don't leave it empty");

        jQuery.validator.addMethod("NoSpecialCharacter", function(value, element) {
            return this.optional(element) || /^[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]+[\u0600-\u065F\u066A-\u06EF\u06FA-\u06FFa-zA-Z ]*$/.test(value);
        }, "No Special Characters");

        $(document).ready(function(){
            $("#visitorCreateForm").validate({
                errorPlacement: function(error, element) {
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                },
                errorElement: "span",
                rules : {
                    name:{
                        required:true,
                        minlength : 2,
                        NoSpecialCharacter: true,
                    },
                    email : {
                        email:true,
                        required:true,
                        minlength : 4,
                    },
                    gender : {
                        required:true,
                    },
                    mobile : {
                        required:true,
                        minlength : 10,
                    },
                    birthyear : {
                        required:true,
                        minlength : 4,
                    }
                },
                messages: {
                    name:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_2_field')",
                        NoSpecialCharacter: "@lang('home.no_numbers_and_SpecialCharacter')",
                    },
                    email : {
                        email:"@lang('home.email_valid_field')",
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                    gender:{
                        required:"@lang('home.required_field')",
                    },
                    mobile:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_10_field')",
                    },
                    birthyear : {
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    }
                },
            });
        });
    </script>
@endsection




