@extends('admin.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.visitors') }}</span>
            </li>
        </ul>


    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.visitors') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    @if(PerUser('visitors_add'))
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/visitors/create') }}" id="sample_editable_1_new" class="btn green"> Add New
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
            </div>
        </div>
    @endif

    @if(PerUser('visitors_view'))
        <div class="row">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-visitors font-dark"></i>
                        <span class="caption-subject bold uppercase">{{ Lang::get('main.visitors') }}</span>
                    </div>
                    <div class="tools"> </div>
                </div>

                <div id="success"></div>

                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="visitor_table">
                        <thead>
                            <tr>
                                <th class="all">#</th>
                                <th class="all"> VisitorName </th>
                                <th class="all"> email </th>
                                <th class="all"> gender </th>
                                <th class="all"> birthyear </th>
                                <th class="all"> mobile </th>
{{--                                <th class="all"> Image </th>--}}
                                <th class="all">{{ Lang::get('main.action') }}</th>
                            </tr>
                        </thead>
                        <body>
                        </body>
                    </table>
                </div>
                </div>
        </div>
    @endif
@endsection

@section('scriptCode')

    <script type="text/javascript">
        $(function () {
            var table = $('#visitor_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('visitors') }}",
                columns: [
                    {data: 'id', name: 'users.id'},
                    {data: 'name', name: 'users.name'},
                    {data: 'email', name: 'users.email'},
                    {data: 'gender', name: 'visitors.gender'},
                    {data: 'birthyear', name: 'visitors.birthyear'},
                    {data: 'mobile', name: 'visitors.mobile'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
        });

        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            @if(PerUser('visitors_delete'))
                $(document).on('click','.delete_this',function(event){
                deleted_id=$(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.visitors') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.visitors') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/visitors') }}/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $('#success').html('<div class="alert dark alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span> </button><b>' + msg + '</b></div>');
                                        $("#visitors-"+deleted_id).slideUp(1000);
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
        });


    </script>

@endsection
