@extends('layouts.site')

@section('content')
    <style>
        #ratingForm ul li{
            margin-top: 20px;
            margin-bottom: 20px;
        }
        #ratingForm button,#ratingForm a{
            width: 80px;
            height: 35px;
            font-size: 10pt;
        }
        .error{
            color:red;
        }
    </style>
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-3">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>  {{trans('home.home')}} </a></li>
                                        <li class="active"> {{trans('home.payment_rating')}} </li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <!-- Freequently Asked Questions section -->
    <div class="xs-section-padding">
        <div class="container">
            <div class="row xs-faq-group">

                <div class="col-12">
                    <div class="align-items-center p-3 m-3 boxing">
                        <h2 class="text-center">@lang('home.The application is optional')</h2>
                        <hr/>
                        @if($sessionQuestion)
                            <div class="alert alert-info">@lang('home.You have answer questions before')</div>
                            <div class="text-center">
                                <a href="{{ route('mysessions') }}" class="btn btn-success">@lang('home.go to session')</a>
                            </div>
                        @else
                        {!! Form::open(['id'=>'ratingForm','url'=>route('pay-session-rating-post',['id'=>$session->id])]) !!}

                        <div class="form-group">
                            <ul>
                                <li>
                                    <input type="hidden" name="question[0]" value="من شجعك على طلب الإستشارة ؟">
                                    <h4 for="">من شجعك على طلب الإستشارة ؟</h4>
                                    <div class="radio">
                                        <label class="p-3">
                                            <input type="radio" name="answer[0]" id="q_1_answer_1" value="أنت">
                                            أنت
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[0]" id="q_1_answer_2" value="الأسرة">
                                            الأسرة
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[0]" id="q_1_answer_3" value="الأصدقاء">
                                            الأصدقاء
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[0]" id="q_1_answer_4" value="طبيب">
                                            طبيب
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[0]" id="q_1_answer_5" value="اخرى">
                                            اخرى
                                        </label>
                                    </div>
                                    <input type="hidden" class="form-control" name="answer_note[0]">
                                </li>
                                <li>
                                    <input type="hidden" name="question[1]" value="كيف عرفت عن موقع New Hayah؟">
                                    <h4 for="">كيف عرفت عن موقع New Hayah؟</h4>
                                    <div class="radio">
                                        <label class="p-3">
                                            <input type="radio" name="answer[1]" id="q_2_answer_1" value="محرك البحث">
                                            محرك البحث
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[1]" id="q_2_answer_2" value="الفيس بوك">
                                            الفيس بوك
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[1]" id="q_2_answer_3" value="انستجرام">
                                            انستجرام
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[1]" id="q_2_answer_4" value="تويتر">
                                            تويتر
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[1]" id="q_2_answer_5" value="صديق">
                                            صديق
                                        </label>
                                    </div>
                                    <input type="hidden" class="form-control" name="answer_note[1]">
                                </li>
                                <li>
                                    <input type="hidden" name="question[2]" value="هل سبق وتلقيت استشارة سابقة ؟">
                                    <h4 for="">هل سبق وتلقيت استشارة سابقة ؟</h4>
                                    <div class="radio">
                                        <label class="p-3">
                                            <input type="radio" name="answer[2]" id="q_3_answer_1" value="نعم">
                                            نعم
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" name="answer[2]" id="q_3_answer_2" value="لا">
                                            لا
                                        </label>
                                    </div>
                                    <input type="hidden" class="form-control" name="answer_note[2]">
                                </li>
                                <li>
                                    <input type="hidden" name="question[3]" value='هل هناك أي مشاكل نفسية أو "أسرية" سابقة'>
                                    <h4 for="">هل هناك أي مشاكل نفسية أو "أسرية" سابقة؟</h4>
                                    <div class="radio">
                                        <label class="p-3">
                                            <input type="radio" class="changeRadio" data-show="answer_note_4" name="answer[3]" id="q_4_answer_1" value="نعم">
                                            نعم
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" class="changeRadio" data-show="answer_note_4" name="answer[3]" id="q_4_answer_2" value="لا">
                                            لا
                                        </label>
                                    </div>
                                    <div class="col-5">
                                        <input type="hidden" class="form-control" id="answer_note_4" name="answer_note[3]">
                                    </div>

                                </li>
                                <li>
                                    <input type="hidden" name="question[4]" value='هل هناك أي مشاكل طبية أو "صحية" سابقة'>
                                    <h4 for="">هل هناك أي مشاكل طبية أو "صحية" سابقة؟</h4>
                                    <div class="radio">
                                        <label class="p-3">
                                            <input type="radio" class="changeRadio" data-show="answer_note_5" name="answer[4]" id="q_5_answer_1" value="نعم">
                                            نعم
                                        </label>
                                        <label class="p-3">
                                            <input type="radio" class="changeRadio" data-show="answer_note_5" name="answer[4]" id="q_5_answer_2" value="لا">
                                            لا
                                        </label>
                                    </div>
                                    <div class="col-5">
                                        <input type="hidden" class="form-control" id="answer_note_5" name="answer_note[4]">
                                    </div>

                                </li>
                                <li>
                                    <input type="hidden" name="question[5]" value='ختار المشكلة أو الاضطراب التي تعاني منها، بإمكانك اختيار أكثر من مشكلة أو اضطراب:'>
                                    <h4 for="">ختار المشكلة أو الاضطراب التي تعاني منها، بإمكانك اختيار أكثر من مشكلة أو اضطراب:</h4>
                                    <div class="checkbox">
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_1" value="القلق">
                                            القلق
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_2" value="الاكتئاب">
                                            الاكتئاب
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_3" value="الوسواس القهري">
                                            الوسواس القهري
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_4" value="الهلع">
                                            الهلع
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_5" value="الهوس">
                                            الهوس
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_6" value="اضطرابات النوم">
                                            اضطرابات النوم
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_7" value="اضطراب كرب ما بعد الصدمة">
                                            اضطراب كرب ما بعد الصدمة
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_8" value="المخاوف المرضية (الفوبيا)">
                                            المخاوف المرضية (الفوبيا)
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_9" value="عدم القدرة على اختيار شريك الحياة.">
                                            عدم القدرة على اختيار شريك الحياة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_6_answer_20" value=" التوقعات الزواجية غير الواقعية من الزوجين.">
                                            التوقعات الزواجية غير الواقعية من الزوجين.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="تأخر سن الزواج والعنوسة.">
                                            تأخر سن الزواج والعنوسة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="مشكلات وخلافات زواجية حادة.">
                                            مشكلات وخلافات زواجية حادة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="المشكلات الخارجية (تدخل أهل الزوجين، وضغوط العمل، والأمراض، إلخ.. .">
                                            المشكلات الخارجية (تدخل أهل الزوجين، وضغوط العمل، والأمراض، إلخ.. .
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="أدمان وتعاطي الازواج.">
                                             أدمان وتعاطي الازواج.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الخلافات على تربية الأبناء.">
                                             الخلافات على تربية الأبناء.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value=" مشكلات المساومة بين الأزواج.">
                                            مشكلات المساومة بين الأزواج.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="مشكلات الطلاق العاطفي والخرس الزواجي.">
                                             مشكلات الطلاق العاطفي والخرس الزواجي.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="اضطرابات نفسية ناتجة عن العلاقات والمؤثرة عليها">
                                            اضطرابات نفسية ناتجة عن العلاقات والمؤثرة عليها
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الخيانة">
                                            الخيانة
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الغيرة المفرطة.">
                                            الغيرة المفرطة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="التعلق المرضى.">
                                            التعلق المرضى.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الاهمال">
                                            الاهمال.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="العنف الأسري">
                                            العنف الأسري.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="ضعف الرغبة الجنسية أو الرغبة الجنسية المفرطة.">
                                            ضعف الرغبة الجنسية أو الرغبة الجنسية المفرطة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value=" تفاوت الرغبة الجنسية بين الزوجين.">
                                            تفاوت الرغبة الجنسية بين الزوجين.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="معتقدات سلبية خاطئة عن العلاقة الحميمة.">
                                            معتقدات سلبية خاطئة عن العلاقة الحميمة.
                                        </label>

                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="العادة السرية.">
                                            العادة السرية.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="إدمان مشاهدة الأفلام الإباحية.">
                                            إدمان مشاهدة الأفلام الإباحية.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الامراض الجنسية النفسية (كجفاف المهبل، وسرعة القذف، وضعف الانتصاب)">
                                            الامراض الجنسية النفسية (كجفاف المهبل، وسرعة القذف، وضعف الانتصاب)
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الآثار النفسية للطلاق.">
                                            الآثار النفسية للطلاق.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="المشكلات النفسية الناتجة عن المشكلات بين الوالدين.">
                                            المشكلات النفسية الناتجة عن المشكلات بين الوالدين.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="صعوبة تربية الأطفال ذوي الاحتياجات الخاصة.">
                                            صعوبة تربية الأطفال ذوي الاحتياجات الخاصة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="سوء العلاقة بين الأبناء والآباء.">
                                            سوء العلاقة بين الأبناء والآباء.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="مشكلات تدني مستوى التحصيل الدراسى.">
                                            مشكلات تدني مستوى التحصيل الدراسى.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="مشاكل قلق الانفصال للأبناء.">
                                            مشاكل قلق الانفصال للأبناء.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="المشكلات السلوكية للأطفال ذات السياق الأسري (الغيرة بين الأبناء، والتنمر، والعناد، والسرقة، ألخ..)">
                                            المشكلات السلوكية للأطفال ذات السياق الأسري (الغيرة بين الأبناء، والتنمر، والعناد، والسرقة، ألخ..)
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="عدم استعداد الطفل لالتحاق بالمدرسة.">
                                            عدم استعداد الطفل لالتحاق بالمدرسة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="ضغوط الأقران.">
                                             ضغوط الأقران.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="أزمة الهوية لدى أبنك المراهق.">
                                            أزمة الهوية لدى أبنك المراهق.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="الاضطرابات العاطفية فى مرحلة المراهقة.">
                                            الاضطرابات العاطفية فى مرحلة المراهقة.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="عدم القدرة على اختيار تخصصي الجامعي ومهنة المستقبل.">
                                            عدم القدرة على اختيار تخصصي الجامعي ومهنة المستقبل.
                                        </label>

                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value=" علاج سوء العلاقة بين الأبناء والأباء.">
                                            علاج سوء العلاقة بين الأبناء والأباء.
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="ضعف المهارات الشخصية والحياتية (كإدارة الضغوط وصنع القرار، والتواصل الرحيم ومهارات القيادة وإدارة الوقت وتوكيد الذات والثقة لبالنفس).">
                                            ضعف المهارات الشخصية والحياتية (كإدارة الضغوط وصنع القرار، والتواصل الرحيم ومهارات القيادة وإدارة الوقت وتوكيد الذات والثقة لبالنفس).
                                        </label>
                                        <label class="p-3">
                                            <input type="checkbox" name="answer[5][]" id="q_1_answer_2" value="أخرى">
                                            أخرى
                                        </label>
                                    </div>
                                    <input type="hidden" class="form-control" name="answer_note[5]">
                                </li>
                                <li>
                                    <div class="form-group">
                                        <input type="hidden" name="question[6]" value='اكتب نبذة عن الشكوى أو المشكلة الحالية :'>
                                        <label for="">اكتب نبذة عن الشكوى أو المشكلة الحالية :</label>
                                        <textarea name="answer[6]" id="question_6" class="form-control"></textarea>
                                        <label for="error-question_6"></label>
                                    </div>
                                    <input type="hidden" class="form-control" name="answer_note[6]">
                                </li>
                                <li>
                                    <div class="form-group">
                                        <input type="hidden" name="question[7]" value='ما الذي تتوقع الاستفادة منه في موقع NEW HAYAH ؟'>
                                        <label for="">ما الذي تتوقع الاستفادة منه في موقع NEW HAYAH ؟</label>
                                        <textarea name="answer[7]" id="question_7" class="form-control"></textarea>
                                        <label for="error-question_7"></label>
                                    </div>
                                    <input type="hidden" class="form-control" name="answer_note[7]">
                                </li>
                            </ul>

                        </div>
                        <div class="text-center">
                            <button class="btn btn-success">حفظ</button>
                            <a href="{{ route('mysessions') }}" class="btn btn-info">تخطي</a>
                        </div>
                        {!! Form::close() !!}
                        @endif
                    </div>

                </div>

            </div><!-- .row END -->
        </div>

    </div><!-- end Freequently Asked Questions section -->


@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){
            $("#ratingForm").validate({
                errorPlacement: function(error, element) {
                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    console.log($(element).is('textarea'))
                    if($(element).is('textarea')){
                        $( element )
                            .closest( "form" )
                            .find( "label[for='error-" + element.attr( "id" ) + "']" )
                            .append( error );
                    }else{
                        $( element )
                            .closest( "li" )
                            .find( "h4" )
                            .append( error );
                    }

                },
                errorElement: "span",
                rules : {
                    "answer[0]" : {
                        required:true,
                    },
                    "answer[1]" : {
                        required:true,
                    },
                    "answer[2]" : {
                        required:true,
                    },
                    "answer[3]" : {
                        required:true,
                    },
                    "answer[4]" : {
                        required:true,
                    },
                    "answer[5][]" : {
                        required:true,
                    },
                },
                messages: {
                    "answer[0]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[1]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[2]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[3]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[4]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[5][]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[6]" : {
                        required:"@lang('home.required_field')",
                    },
                    "answer[7]" : {
                        required:"@lang('home.required_field')",
                    },
                },
            });
            $(document).on('change','.changeRadio',function(){
                if($(this).val()=='نعم'){
                    $("#"+$(this).attr('data-show')).attr('type','text');
                }else{
                    $("#"+$(this).attr('data-show')).attr('type','hidden');
                }
            })
        });
    </script>
@endsection

