@extends('layouts.site')

@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-5">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('home.medical-plans') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow" style="width: 150px; height: 150px;" />
                            <h4 class="mt-5 colorsite">{{$userData->name}}</h4>
                            <div>
                                <label>@lang('home.sessions-count'): {{ \App\Sessions::with('visitor')->where('visitor_id',$userData->visitor->id)->count() }}</label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('getPlan')}}">
                                <i class="fas fa-play"></i><br />
                                {{ trans('auth.medical_plans') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white">
                    @if (session()->has('success'))
                        <div class="alert alert-dismissable alert-success">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <strong class="mx-3">
                                {!! session()->get('success') !!}
                            </strong>
                        </div>
                    @endif
                    

                    <div class="mr1 text-right">
                        <h3 class="mt-5 colorsite font-weight-bold"> {{trans('home.client-send-message') }} </h3>
                    </div>
                    
                        <div class="accordion mt-5" id="faqExample">
                            @foreach($allMessages  as $key=>$messageInfo)
                            <div class="card">
                                <div class="card-header p-2" style="background: #cccaca;" id="heading-{{ $messageInfo->id }}">
                                    <h5 class="mb-0" style="color:black;">
                                        <button style="color:black;" class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapse-{{ $messageInfo->id }}" aria-expanded="true" aria-controls="collapse-{{ $messageInfo->id }}">
                                            السؤال :
                                            {{ $messageInfo->message }}
                                        </button>
                                    </h5>
                                    <h6 style="position: absolute;left: 10px;top: 9px;color: black;">
                                        {{date('Y-m-d H:i:s', strtotime($messageInfo->created_at))}}
                                    </h6>
                                </div>

                                <div id="collapse-{{ $messageInfo->id }}" class="collapse @if($loop->first) show @endif" aria-labelledby="heading-{{ $messageInfo->id }}" data-parent="#faqExample">
                                    <div class="card-body">
                                        <b>الإجابة:</b>
                                        <div id="message-{{ $messageInfo->id }}">
                                            @if($messageInfo->answer)
                                                {{ $messageInfo->answer }}
                                            @else

                                                @if( $messageInfo->type =='patient')
                                                 <p class="alert alert-info"> في انتظار رد المعالج </p>
                                                @else
                                                <div class="form-group">
                                                    <textarea name="answer_question" data-id="{{ $messageInfo->id }}" id="answer_question_{{ $messageInfo->id }}" class="form-control"></textarea>
                                                </div>
                                                <div class="text-center">
                                                    <button class="btn btn-success saveAnswer" data-id="{{ $messageInfo->id }}">ارسال الأجابة</button>
                                                </div>
                                                @endif

                                                
                                            @endif 
                                        </div>

                                    </div>
                                </div>
                                
                            </div>
                            @endforeach
                        </div>
                    
                    @if($treatmentPlan->allow_chat)
                        <!-- @if(($lastMessage&&$lastMessage->answer!=null)||!$lastMessage) -->
                            <form method="POST" action="{{route('client-send-message',$client_session)}}" class="col align-self-center">
                                @csrf
                                 <input type="hidden" name="type" value="patient">
                                {{--                                                                        <input type="hidden" name="session_id" value="{{$client_session->id}}">--}}
                                <div class="form-group">
                                    <h4 for="validationDefault01" class="text-center"><strong> نص الرسالة</strong></h4>
                                    <div class="formelement">
                                        <div class="forminputdiv">
                                            <div class="form-group col-md-12">
                                                {{ Form::textarea('message',old('message'), ['placeholder' => 'اكتب نص رسالتك كاملة', 'class' => 'form-control forminput' , 'cols' => 20, 'rows' =>5, 'required' => 'required']) }}
                                            </div>
                                        </div>
                                    </div>
                                    @if ($errors->has('message'))
                                        <span class="alert alert-danger" role="alert">
                                     <strong>{{ $errors->first('message') }}</strong>
                                </span>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 text-center">
                                        <button type="submit" class="lgx-btn mt-5" style="width:30%">
                                            {{ trans('auth.send') }}
                                        </button>
                                    </div>
                                </div>

                            </form>
                        <!-- @endif -->
                    @else
                        <div class="alert alert-info">@lang('home.you need the therapist to allow chat with him')</div>
                    @endif
                </div>




            </div>
        </div>
    </div>

@endsection

@section('scriptSection')
    <script>
        $(document).ready(function(){
            token= '{{ csrf_token() }}';
            $(document).on('click','.saveAnswer',function(){
                el=$(this);
                el.attr('disabled','disabled');
                message_id=$(this).attr('data-id');
                answer=$('#answer_question_'+message_id).val();
                $.ajax({
                    type: "POST",
                    url: "{{ URL('client-messages/'.$treatmentPlan->session_id) }}",
                    data: {"answer": answer, "message_id": message_id,_token:token, 'type':'patient'},
                    success: function (msg) {
                       if(msg.success){
                           $("#message-"+message_id).html(answer);
                           setTimeout(function(){
                            window.location.reload()
                           },500);
                       }
                       el.removeAttr('disabled');
                    }
                });
            })
        });
    </script>
@endsection
