@extends('layouts.site')

@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area">
                                    <ul class="breadcrumb mt-3">
                                        @if(config('app.locale') == "en")
                                        <li class="active"> {{trans('home.send-complain')}} </li>
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        @else
                                            <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                            <li class="active"> {{trans('home.send-complain')}} </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    @if(Session::has('message'))
        <p class="alert alert-success alert-dismissible fade show mt-2 text-center" role="alert">{{ Session::get('message') }}
            <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </p>
    @endif

    <!-- profile data -->
    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">

                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2 mx-3">
                        <div class="col-md-12 float-right pt-5 text-center">
                            @if(!empty($userData->visitor->image))
                                <img src="{{asset('avatars/visitors/'.$userData->visitor->image)}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                            @else
                                <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                                <h4 class="mt-3 colorsite">{{ $userData->name }}</h4>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-md-9 boxing bg-white mb-5">
                    <div class="lgx-tab p-3">
                        <div class="align-items-center">
                            <form method="POST" id="createComplaintForm" action="{{route('insert-complaint')}}" class="col align-self-center">
                             @csrf
                                <div class="form-group">
                                    <h4> {{ trans('home.complaint-title')  }} </h4>
                                    <input id="title" type="text" class="forminput form-control @error('title') is-invalid @enderror mb-4" name="title" value="{{ old('title') }}" autocomplete="title" autofocus
                                           data-parsley-maxlength="30"
                                           data-parsley-required="true"
                                           data-parsley-required-message="{{trans('home.input-required')}}"
                                    >
                                    <label for="error-title"></label>
                                    @if ($errors->has('title'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('title') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <h4 id="complaint-subject"> {{ trans('home.complaint-subject')  }} </h4>
                                    <div class="form-group">
                                        {{ Form::textarea('subject',old('subject'), ['placeholder' => '','id'=>'subject'  ,'class' => 'form-control forminput '.($errors->has('subject')?'is-invalid':'') , 'cols' => 20, 'rows' =>5]) }}
                                        <label for="error-subject"></label>
                                        @if ($errors->has('subject'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('subject') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 text-center">
                                        <button type="submit" class="lgx-btn mt-5" style="width:30%">
                                            {{ trans('home.send') }}
                                        </button>
                                    </div>
                                </div>


                            </form>
                        </div> <!-- row -->
                    </div>
                </div>

        </div> <!-- container -->
    </div>  <!-- mt-5 -->
@endsection
        @section('scriptSection')
            <script>
                jQuery.validator.addMethod("noSpace", function(value, element) {
                    return value.trim().length != 0 && value != "";
                }, "No space please and don't leave it empty");

                $("#createComplaintForm").validate({
                    errorPlacement: function(error, element) {
                        // Append error within linked label
                        console.log('error')
                        console.log(error)
                        console.log(element)
                        console.log(element.attr( "id" ))
                        $( element )
                            .closest( "form" )
                            .find( "label[for='error-" + element.attr( "id" ) + "']" )
                            .append( error );
                    },
                    errorElement: "span",
                    rules : {
                        title : {
                            required:true,
                            minlength : 4,
                            noSpace:true
                        },
                        subject : {
                            required:true,
                            minlength:4,
                            noSpace:true
                        },
                    },
                    messages: {
                        title : {
                            required:"@lang('home.required_field')",
                            minlength : "@lang('home.minlength_4_field')",
                            noSpace:"@lang('home.prevent_space_text')",
                        },
                        subject:{
                            required:"@lang('home.required_field')",
                            minlength : "@lang('home.minlength_4_field')",
                            noSpace:"@lang('home.prevent_space_text')",
                        },
                    },
                });
            </script>
@endsection

