@extends('layouts.site')

@section('content')

    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg">
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-5">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('home.medical-plans-view') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <div class="mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="boxing bg-white border row ml-2">
                        <div class="col-md-12 float-right pt-5 text-center">
                            <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow" style="width: 150px; height: 150px;" />
                            <h4 class="mt-5 colorsite">{{$data->user->name}}</h4>
                            <div>
                                <label>@lang('home.sessions-count'): {{$data->sessions->where('session_status','reserved')->count()}}</label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-5 row clearfix text-center ml-2">
                        <div class="col-6 mb-4">
                            <a href="{{route('getPlan')}}">
                                <i class="fas fa-play"></i><br />
                                {{ trans('auth.medical_plans') }}
                            </a>
                        </div>
                    </div>

                </div>


                <div class="col-md-9 boxing bg-white">
                    <button style="font-size: 12px;padding: 5px 20px;" onclick="generatePDF()" class="btn btn-success float-left"> تحميل  <i class="fa fa-file-pdf" ></i></button>


                    <div class="lgx-tab p-3" id="report_PDF">



                        <div class="align-items-center">

                            <div class="row px-5">

                                <div class="col-md-12">
                                    <h1 id="report_title" style="color: black;font-size: 29px;font-weight: bold;text-align: center;"></h1>
                                </div>
                                <div class="col-md-12">
                                     <img src="{{asset('assets/img/logo.png')}}"  alt="New Life" id="logo" style="display: none;width: 40%;margin: 0 auto;margin-bottom: 30px; " />
                                </div>


                                <div class="col-md-3">
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.serial-number') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value "> {{ $planData->serial_number  }}  </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <p class="client_name_pdf" data-id="{{$planData->client_name_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.client-name') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value mx-5"> {{$data->user->name }}  </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                     <p class="age_pdf" data-id="{{$planData->age_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.age') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value mx-3"> {{ $planData->age  }}  </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <p class="gender_pdf" data-id="{{$planData->gender_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.gender') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value "> {{ $planData->gender == 1 ? trans('home.male') : trans('home.female')   }}  </div>
                                        </div>
                                    </div>
                                </div>
                            </div><hr/>

                            <div class="row px-5  mt-5">
                                <div class="col-md-6">
                                    <p class="problem_pdf" data-id="{{$planData->problem_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.Problem Type') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value ">
                                                @if($planData->problem == 1)
                                                    {{trans('home.Marital-and-Family-Problems')}}
                                                @elseif($planData->problem == 2)
                                                    {{trans('home.Marital-Rehabilitation')}}
                                                @elseif($planData->problem == 3)
                                                    {{trans('home.Sexual-Therapy')}}
                                                @elseif($planData->problem == 4)
                                                    {{trans('home.Post-Divorce-Rehabilitation')}}
                                                @elseif($planData->problem == 5)
                                                    {{trans('home.Recovery-from-Divorce')}}
                                                @elseif($planData->problem == 6)
                                                    {{trans('home.Children-Mental-Disorders')}}
                                                @elseif($planData->problem == 7)
                                                    {{trans('home.Children-Problems')}}
                                                @elseif($planData->problem == 8)
                                                    {{trans('home.Adolescent-Mental-Disorders')}}
                                                @elseif($planData->problem == 9)
                                                    {{trans('home.Adolescent-Problems')}}
                                                @else
                                                    {{trans('home.Other')}}
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                     <p class="problem_description" data-id="{{$planData->problem_description_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.problem_description') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value "> {{ $planData->problem_description  }}  </div>
                                        </div>
                                    </div>
                                </div>
                            </div><hr/>

                            <div class="row px-5 mt-5">
                                <div class="col-md-6">
                                    <p class="diagnostic_pdf" data-id="{{$planData->diagnostic_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.diagnostic') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value mx-3">
                                                {{--@if($planData->diagnostic == 1)
                                            <div class="form-input-value ">
                                                @if($planData->diagnostic == 1)
                                                    {{trans('home.Underachievement')}}
                                                @elseif($planData->diagnostic == 2)
                                                    {{trans('home.Disorganized-in-Assignments')}}
                                                @elseif($planData->diagnostic == 3)
                                                    {{trans('home.academic-procrastination')}}
                                                @elseif($planData->diagnostic == 4)
                                                    {{trans('home.Lack-of-clarity-of-objectives')}}
                                                @elseif($planData->diagnostic == 5)
                                                    {{trans('home.Generalized-Anxiety')}}
                                                @elseif($planData->diagnostic == 6)
                                                    {{trans('home.OCD')}}
                                                @elseif($planData->diagnostic == 7)
                                                    {{trans('home.Conduct-disorder')}}
                                                @elseif($planData->diagnostic == 8)
                                                    {{trans('home.Enuresis')}}
                                                @elseif($planData->diagnostic == 9)
                                                    {{trans('home.Panic-Attack')}}
                                                @elseif($planData->diagnostic == 10)
                                                    {{trans('home.Smoking')}}
                                                @elseif($planData->diagnostic == 11)
                                                    {{trans('home.Family-conflict')}}
                                                @elseif($planData->diagnostic == 12)
                                                    {{trans('home.Academic-and-Psychological-Stress')}}
                                                @elseif($planData->diagnostic == 13)
                                                    {{trans('home.Depression')}}
                                                @elseif($planData->diagnostic == 14)
                                                    {{trans('home.Bipolar-disorder')}}
                                                @elseif($planData->diagnostic == 15)
                                                    {{trans('home.Social-Phobia')}}
                                                @elseif($planData->diagnostic == 16)
                                                    {{trans('home.Test-Anxiety')}}
                                                @elseif($planData->diagnostic == 17)
                                                    {{trans('home.Substance-Abuse')}}
                                                @elseif($planData->diagnostic == 18)
                                                    {{trans('home.Sexual-disorders')}}
                                                @elseif($planData->diagnostic == 19)
                                                    {{trans('home.Borderline-personality-disorder')}}
                                                @elseif($planData->diagnostic == 20)
                                                    {{trans('home.Insomnia')}}
                                                @else
                                                    {{trans('home.Other')}}
                                                @endif--}}
                                                @foreach(\App\Diagnosis::whereIn('id',\App\TreatmentPlansDiagnosis::where('treatment_plan_id',$planData->id)->pluck('diagnosis_id')->toArray())->pluck('title_'.config('app.locale'))->toArray() as $diag)
                                                    {{ $diag }},
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <p class="therap_evaluation_pdf" data-id="{{$planData->therap_evaluation_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.therap_evaluation') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value ">
                                                @if($planData->therap_evaluation == 1)
                                                    {{trans('home.BASIC-ID')}}
                                                @elseif($planData->therap_evaluation == 2)
                                                    {{trans('home.Holland-Test-for-Career-Tendencies')}} 
                                                @elseif($planData->therap_evaluation == 3)
                                                    {{trans('home.Beck-Depression-Inventory')}}
                                                @elseif($planData->therap_evaluation == 4)
                                                    {{trans('home.EPQ')}}
                                                @elseif($planData->therap_evaluation == 5)
                                                    {{trans('home.Yale–Brown-Y-BOCS')}}
                                                @elseif($planData->therap_evaluation == 6)
                                                    {{trans('home.Family-Readiness-Scale')}}
                                                @elseif($planData->therap_evaluation == 7)
                                                    {{trans('home.Taylor-manifest-anxiety-scale')}}
                                                @elseif($planData->therap_evaluation == 8)
                                                    {{trans('home.Adolescent-Identity-Crisis-Scale')}}
                                                @elseif($planData->therap_evaluation == 9)
                                                    {{trans('home.Domestic-Violence-Scale')}}
                                                @elseif($planData->therap_evaluation == 10)
                                                    {{trans('home.Parenting-Style-Scale')}}
                                                @elseif($planData->therap_evaluation == 11)
                                                    {{trans('home.Sexual-Orientation-Scale')}}
                                                @else
                                                    {{trans('home.Other')}}
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div><hr/>

                            <div class="form-group p-2 mt-3">
                                <p class="table_pdf" data-id="{{$planData->table_pdf}}"></p>
                                <h4 for="validationDefault01" class="text-center"><strong>   {{trans('home.previous-sessions')}} </strong></h4>
                                <div class="formelement">
                                    <div class="forminputdiv">
                                        <div class="portlet-body text-center">
                                            <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="sample_1">
                                                <thead>
                                                <tr class="text-center">
                                                    <th>{{trans('home.session-number')}}</th>
                                                    <th>{{trans('home.date-time')}}</th>
                                                    <th>{{trans('home.period')}}</th>
                                                    <th>{{trans('home.attend')}}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($sessionsAttend as $session_attend)
                                                    <tr id="sessions-{{ $session_attend->id }}" class="text-center" tabindex="9">
                                                        <td>{{ $session_attend->id }}</td>
                                                        <td>{{ date('Y-m-d H:i:s', strtotime($session_attend->start_time)) }}</td>
                                                        <td>{{ $session_attend->type }}</td>
                                                        <td>
                                                            @if($session_attend->attend==1)
                                                                <i class="fa fa-check" aria-hidden="true"></i>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div><hr/>

                            <div class="row px-5  mt-5">
                                <div class="col-md-6">
                                    <p class="long_term_pdf" data-id="{{$planData->long_term_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.short-term') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value "> {{ $planData->long_term  }}  </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <p class="short_term_pdf" data-id="{{$planData->short_term_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.long-term') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value "> {{ $planData->short_term  }}  </div>
                                        </div>
                                    </div>
                                </div>
                            </div><hr/>

                            <div class="row px-5  mt-5">
                                <div class="col-md-6">
                                    <p class="therapeutic_intervention_pdf" data-id="{{$planData->therapeutic_intervention_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.therapeutic_intervention') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value ">

                                                {{--@if($planData->therapeutic_intervention == 1)
                                                    {{trans('home.CBT')}}
                                                @elseif($planData->therapeutic_intervention == 2)
                                                    {{trans('home.Behavioural-Therapy')}}
                                                @elseif($planData->therapeutic_intervention == 3)
                                                    {{trans('home.Person-centered-therapy')}}
                                                @elseif($planData->therapeutic_intervention == 4)
                                                    {{trans('home.Reality-Therapy')}}
                                                @elseif($planData->therapeutic_intervention == 5)
                                                    {{trans('home.Multimodal-Therapy')}}
                                                @elseif($planData->therapeutic_intervention == 6)
                                                    {{trans('home.Solution-focused-brief-therapy-(SFBT)')}}
                                                @elseif($planData->therapeutic_intervention == 7)
                                                    {{trans('home.DBT')}}
                                                @elseif($planData->therapeutic_intervention == 8)
                                                    {{trans('home.logo-therapy')}}
                                                @elseif($planData->therapeutic_intervention == 9)
                                                    {{trans('home.Expressive-therapy')}}
                                                @elseif($planData->therapeutic_intervention == 10)
                                                    {{trans('home.Psychoeducation')}}
                                                @elseif($planData->therapeutic_intervention == 11)
                                                    {{trans('home.Gestalt-therapy')}}
                                                @elseif($planData->therapeutic_intervention == 12)
                                                    {{trans('home.Acceptance-and-commitment-therapy-(ACT)')}}
                                                @elseif($planData->therapeutic_intervention == 13)
                                                    {{trans('home.EMDR')}}
                                                @else
                                                    {{trans('home.Other')}}
                                                @endif--}}
                                                @foreach(\App\Treatments::whereIn('id',\App\TreatmentPlansTreatments::where('treatment_plan_id',$planData->id)->pluck('treatments_id')->toArray())->pluck('title_'.config('app.locale'))->toArray() as $diag)
                                                    {{ $diag }},
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <p class="transfer_pdf" data-id="{{$planData->transfer_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.transfer') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value ">
                                                @if($planData->transfer == 1)
                                                    {{trans('home.no-transfer')}}
                                                @elseif($planData->transfer == 2)
                                                    {{trans('home.clinical-psychologist')}}
                                                @else
                                                    {{trans('home.psychiatrist')}}
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div><hr/>


                            <div class="row px-5 mt-5">
                                <div class="col-md-6">
                                    <p class="current_status_pdf" data-id="{{$planData->current_status_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.current_status') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value ">
                                                {{ $planData->current_status == 1 ? trans('home.in-progress') : trans('home.closed') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <p class="last_visit_pdf" data-id="{{$planData->last_visit_pdf}}"></p>
                                    <div class="formelement mb-5">
                                        <div class="formlabel mb-3">
                                            <h4> {{ trans('home.last_visit') }} </h4>
                                        </div>
                                        <div class="forminputdiv">
                                            <div class="form-input-value ">
                                                {{ $planData->last_visit }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div><hr/>

                            <div class="form-group px-5 mt-5">
                                <p class="homework_pdf" data-id="{{$planData->homework_pdf}}"></p>
                                <h4 for="validationDefault01" class="text-center"><strong> الواجبات </strong></h4>
                                <div class="formelement">
                                    <div class="forminputdiv">
                                        <div class="form-group text-center">
                                            {{ $planData->homework }}
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div> <!-- row -->
                    </div>




                </div>
            </div>
        </div>
    </div>
@endsection


@push('downloadPDF')

<script src="{{ asset('assets/html2pdf.bundle.min.js') }}"></script>

    <script>
      function generatePDF() {
        $("#logo").css('display', 'block');

        var pdf1 = $(".client_name_pdf").attr('data-id');
        var pdf2 = $(".age_pdf").attr('data-id');
        var pdf3 = $(".gender_pdf").attr('data-id');
        var pdf4 = $(".problem_pdf").attr('data-id');
        var pdf5 = $(".problem_description").attr('data-id');
        var pdf6 = $(".diagnostic_pdf").attr('data-id');
        var pdf7 = $(".therap_evaluation_pdf").attr('data-id');
        var pdf8 = $(".table_pdf").attr('data-id');
        var pdf9 = $(".long_term_pdf").attr('data-id');
        var pdf10 = $(".short_term_pdf").attr('data-id');
        var pdf11 = $(".therapeutic_intervention_pdf").attr('data-id');
        var pdf12 = $(".transfer_pdf").attr('data-id');
        var pdf13 = $(".current_status_pdf").attr('data-id');
        var pdf14 = $(".last_visit_pdf").attr('data-id');
        var pdf15 = $(".homework_pdf").attr('data-id');

        if(pdf1 == '0')
        {
           $(".client_name_pdf").parent().css('display', 'none');
        }
        if(pdf2 == '0')
        {
           $(".age_pdf").parent().css('display', 'none');
        }
        if(pdf3 == '0')
        {
           $(".gender_pdf").parent().css('display', 'none');
        }
        if(pdf4 == '0')
        {
           $(".problem_pdf").parent().css('display', 'none');
        }

        if(pdf5 == '0')
        {
           $(".problem_description").parent().css('display', 'none');
        }
        if(pdf6 == '0')
        {
           $(".diagnostic_pdf").parent().css('display', 'none');
        }
        if(pdf7 == '0')
        {
           $(".therap_evaluation_pdf").parent().css('display', 'none');
        }
        if(pdf8 == '0')
        {
           $(".table_pdf").parent().css('display', 'none');
        }

        if(pdf9 == '0')
        {
           $(".long_term_pdf").parent().css('display', 'none');
        }
        if(pdf10 == '0')
        {
           $(".short_term_pdf").parent().css('display', 'none');
        }
        if(pdf11 == '0')
        {
           $(".therapeutic_intervention_pdf").parent().css('display', 'none');
        }
         if(pdf12 == '0')
        {
           $(".transfer_pdf").parent().css('display', 'none');
        }
         if(pdf13 == '0')
        {
           $(".current_status_pdf").parent().css('display', 'none');
        }
         if(pdf14 == '0')
        {
           $(".last_visit_pdf").parent().css('display', 'none');
        }
        if(pdf15 == '0')
        {
           $(".homework_pdf").parent().css('display', 'none');
        }



         $("#report_title").text(' تقرير الخطه العلاجية ');


        // Choose the element that our report_PDF is rendered in.
        const element = document.getElementById("report_PDF");
        // Choose the element and save the PDF for our user.
        html2pdf()
          .from(element)
          .save();
      }
    </script>

@endpush
