@extends('layouts.site')

@section('content')

<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-5">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('auth.login')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>
<div class="lgx-schedule">
    <div class="container-fluid loginstyle">
        <div class="row d-flex justify-content-start lgx-inner ">
                    <div class="col-md-7">
                        <div id="lgx-testimonials"  class="lgx-testimonials">
                            <div class="lgx-inner ">
                                <div class="container">
                                    <div class="lgx-content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="lgx-testiowlarea">
                                                    <div id="lgx-owltestimonial" class="owl-carousel lgx-owltestimonial">
                                                        @foreach ($services as $item)
                                                        <div class="item lgx-fadeInLeft">
                                                            <figure class="lgx-client-image">
                                                                <figcaption class="lgx-zoomIn-q">
                                                                    <i class="fa fa-quote-left"></i>
                                                                </figcaption>
                                                            </figure>
                                                            <div class="testi-info-area">
                                                                <p class="lgx-review">
                                                                    {{ config('app.locale') == "ar" ?  $item->title_ar : $item->title_en }}
                                                                </p>
                                                            </div>
                                                        </div> <!--//.Item-->
                                                        @endforeach
                                                    </div><!--l//#LGX-OWL TESTIMONIAL-->
                                                </div>
                                            </div> <!--//.COL 12 -->
                                        </div> <!--//.ROW-->
                                    </div> <!--//.LGX CONTENT-->
                                </div> <!--//.CONTAINER-->
                            </div><!--//.LGX INNER-->
                        </div>
                    </div>
                    <div class="col-md-5" >
                        <div class="lgx-tab">

                            @if(Session::has('status'))
                                <p class="alert alert-success alert-dismissible fade show mt-2" role="alert">{{ Session::get('status') }}
                                    <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </p>
                            @endif

                            @if(Session::has('dis-allow'))
                                <p class="alert alert-success alert-dismissible fade show mt-2" role="alert">{{ Session::get('dis-allow') }}
                                    <button type="button" class="close text-center" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </p>
                            @endif
                            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" id="doctor-login-tab" data-toggle="pill" href="#doctor-login" role="tab" aria-controls="doctor-login" aria-selected="false">{{trans('auth.therapist')}}</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" id="visitor-login-tab" data-toggle="pill" href="#visitor-login" role="tab" aria-controls="visitor-login" aria-selected="true">{{trans('auth.visitor')}}</a>
                                </li>
                            </ul>

                        <div class="tab-content lgx-tab-content" id="pills-tabContent">
                            <div class="tab-pane fade align-items-center p-5" id="doctor-login" role="tabpanel" aria-labelledby="doctor-login-tab">
                                <form method="POST" id="therapistsLoginForm" action="{{ route('therapists_login') }}" class="col align-self-center">
                                    @csrf
                                    @error('error')
                                    <div class="alert alert-danger">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">
                                            &times;
                                        </button>
                                        {{ $message }}
                                    </div>
                                    @enderror
                                    <input type="hidden" name="type" value="therapist" />
                                    <div class="form-group">
                                        <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autofocus placeholder="{{trans('auth.email')}}">
                                        <label for="error-email"></label>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                        <div class="form-group">
                                            <input id="password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password" required placeholder="{{trans('auth.password')}}">
                                            <label for="error-password"></label>
                                            @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    <div class="col-xs-6">
                                        <div class="checkbox-nice dir-rtl text-right">
                                            <input type="checkbox" name="remember" id="remember-me">
                                            <label for="remember-me">
                                                @lang('home.Remember me')
                                            </label>
                                        </div>
                                    </div>

                                        <div class="form-group">
                                            <div class="col-md-12 px-0">
                                                <button id="buttonther" type="submit" class="btn btn-info btn-lg mt-3" style="width: 100%">
                                                    {{ trans('auth.login') }}
                                                </button>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <a href="{{route('password.request')}}">
                                                {{trans('auth.forget')}}
                                            </a>
                                        </div>

                                    <div>
                                        <a href="{{route('therapist_signup')}}">{{ trans('auth.therapists.signup') }}</a>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade show active align-items-center p-5" id="visitor-login" role="tabpanel" aria-labelledby="visitor-login-tab">
                                <form method="POST" id="loginVisitorForm" action="{{ route('login') }}" class="col align-self-center">
                                    @csrf
                                    @error('error')
                                    <div class="alert alert-danger">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">
                                            &times;
                                        </button>
                                        {{ $message }}
                                    </div>
                                    @enderror
                                    <input type="hidden" name="type" value="visitor" />
                                    <div class="form-group">
                                        <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autofocus placeholder="{{trans('auth.email')}}">
                                        <label for="error-email"></label>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                        <div class="form-group">
                                            <input id="password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password" required placeholder="{{trans('auth.password')}}">
                                            <label for="error-password"></label>
                                            @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-xs-6">
                                            <div class="checkbox-nice dir-rtl text-right">
                                                <input type="checkbox" name="remember" id="remember-me">
                                                <label for="remember-me">
                                                    @lang('home.Remember me')
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group ">
                                            <div class="col-md-12 px-0">
                                                <button id="visitbuton" type="submit" class="btn btn-info btn-lg mt-3" style="width: 100%">
                                                    {{ trans('auth.login') }}
                                                </button>
                                            </div>
                                        </div>
                                    <hr>
                                   <!-- <h4>@lang('home.OR')</h4> -->
                                    <!-- <a href="{{ route('social_login',['social'=>'facebook']) }}" class="btn btn-lg btn-facebook btn-block">@lang('home.Login via facebook')</a>
                                    <a href="{{ route('social_login',['social'=>'google']) }}" class="btn btn-lg btn-google btn-block">@lang('home.Login via google')</a> -->
                                        <!-- forget password here -->
                                        <div class="form-group">
                                            <a href="{{route('password.request')}}">
                                                {{trans('auth.forget')}}
                                            </a>
                                        </div>
                                        <div>
                                            <a href="{{route('register')}}">{{ trans('auth.signup-now') }}</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
        </div>
    </div>
</div>
@endsection
@section('scriptSection')
    <script>
        $(document).ready(function(){



            $("#therapistsLoginForm").validate({

                errorPlacement: function(error, element) {
                    // Append error within linked label
                    document.getElementById('buttonther').onclick = function() {

                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                 } },
                errorElement: "span",
                rules : {
                    email : {
                        email:true,
                        required:true,
                        minlength : 4,
                    },
                    password:{
                        required:true,
                        minlength : 4,
                    },
                },
                messages: {
                    email : {
                        email:"@lang('home.email_valid_field')",
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                    password:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                },
            });
            $("#loginVisitorForm").validate({
                errorPlacement: function(error, element) {
                    document.getElementById('visitbuton').onclick = function() {

                    // Append error within linked label
                    console.log('error')
                    console.log(error)
                    console.log(element)
                    console.log(element.attr( "id" ))
                    $( element )
                        .closest( "form" )
                        .find( "label[for='error-" + element.attr( "id" ) + "']" )
                        .append( error );
                }},
                errorElement: "span",
                rules : {
                    email : {
                        email:true,
                        required:true,
                        minlength : 4,
                    },
                    password:{
                        required:true,
                        minlength : 4,
                    },
                },
                messages: {
                    email : {
                        email:"@lang('home.email_valid_field')",
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                    password:{
                        required:"@lang('home.required_field')",
                        minlength : "@lang('home.minlength_4_field')",
                    },
                },
            });

        });
    </script>
@endsection
