@extends('layouts.site')

@section('content')
    <style type="text/css">
        .count-down
        {
            font-size: 15px;
        }
        .next-ses {
            text-align: center;
            border: 1px solid #ddd;
            margin-bottom: 30px
        }
        .bg-available{
            background-color: #339c40;
        }
        .bg-reserved{
            background-color: #339c40;
        }
        .bg-cancelled{
            background-color: #f37673;
        }
        .next-ses .ses-title {

            color: #fff;
            text-align: right;
            padding: 5px 20px;
            margin: 0;
            font-size: 14px
        }

        .next-ses .ses-title span {
            float: left
        }

        .next-ses .ses-name {
            background-color: #f5f5f5;
            padding: 10px 20px;
            color: #f0855b;
            font-weight: bold;
            border-bottom: 1px solid #ddd;
            margin: 0
        }

        .time-cont {
            display: flex;
            flex-direction: row;
            flex-wrap: nowrap;
            align-content: space-between;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px
        }

        .time-cont .date {
            display: inline-block;
            width: 50%;
            border-left: 1px solid #ddd;
            height: 100%;
            margin: 0;
            padding: 20px;
            font-weight: bold;
            font-size: 14px;
            color: #4d4d4f
        }

        .time-cont .date i {
            font-size: 18px;
            margin-bottom: 10px
        }

        .time-cont .time {
            display: inline-block;
            width: 50%;
        }

        .time-cont .time i {
            font-size: 18px;
            color: #4d4d4f
        }

        .time-cont .time p {
            display: inline-block;
            width: 48%;
            margin: 0;
            color: #4d4d4f
        }

        .time-cont .time p:first-of-type {
            color: #67bfd5;
            font-size: 13px;
            width: 30%;
        }

        .time-cont .time p:last-of-type {
            text-align: right;
            font-size: 12px;
            vertical-align: top;
            width: 62%;
        }

        /* .time-cont .time p span {
             margin-right: 9px;
         }*/

        .com-btns {
            display: flex
        }

        .com-btns button {
            width: 100%;
            margin: 0;
            border: none;
            outline: none;
            padding: 5px;
            font-size: 14px;
            color: #fff;
            transition: .1s ease-in-out
        }

        .com-btns button:first-of-type {
            background-color: #cdccc8;
        }

        .com-btns button:last-of-type {
            background-color: #f44f4b;
        }

        .com-btns button:hover {
            opacity: .9
        }
    </style>
    <style>
        .error{
            color:red;
        }
        .ui-dialog.ui-corner-all.ui-widget{
            padding: 0;
        }
        .ui-widget-header {
            border: 1px solid #dfb3ff;
            background: #73bffe;
            color: #ffffff;
            font-weight: bold;
        }
        .ui-button-icon-only.ui-dialog-titlebar-close{
            border-color: #b4b4b4;
            background: #ffffff;
            border-radius: 50%;
        }
        .ui-dialog-title{
            font-size: 20px;
        }
    </style>
<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-5">
                                <ul class="breadcrumb">
                                    @if(config('app.locale') == "en")
                                    <li class="active">{{trans('auth.mysessions') }}</li>
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    @else
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active">{{trans('auth.mysessions') }}</li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="mt-5 mb-5">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="boxing bg-white border row ml-2 mx-2">
                    <div class="col-md-12 float-right pt-5 text-center">


                        @if(!empty($userData->visitor->image))
                         <img src="{{asset('avatars/visitors/'.$userData->visitor->image)}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                        @else
                            <img src="{{asset('avatars/visitors/pp.svg')}}" class="rounded-circle card-img-top shadow mb-3 " style="width: 150px; height: 150px;" />
                        @endif

                        <h4 class="mt-5 colorsite">{{$data->user->name}}</h4>
                        <div>
                            <label>@lang('home.sessions-count'): {{$data->sessions()->whereNotIn('session_status',['cancelled','visitor_cancelled'])->count()}}</label>
                        </div>
                    </div>
                </div>

                <div class="mt-5 row clearfix text-center ml-2">
                    <div class="col-5 mb-4">
                        <a href="{{route('getPlan')}}">
                            <i class="fas fa-play"></i><br />
                            {{ trans('home.client-file') }}
                        </a>
                    </div>


                    @if ((auth()->check()&&auth()->user()->type == 'visitors')||!auth()->check())
                    <div class="col-7 mb-4">
                        <a href="{{route('page_view',getStaticPageValue(11,'url')) }}"> <i class="fas fa-archive"></i> <br> {{ getStaticPageValue(11) }}</a>
                    </div>
                    @endif

                    


                </div>

            </div>

            <div class="col-md-9 boxing bg-white">
                    @if (session()->has('success'))
                        <div class="alert alert-dismissable alert-success">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <strong class="mx-3">
                                {!! session()->get('success') !!}
                            </strong>
                        </div>
                    @endif
                <div class="mr1">
                    <h3 class="mt-5 colorsite font-weight-bold">{{trans('home.sessions')}}</h3>
                </div>

                <div class=" p-2 ">

                    <section>
                        <div id="lgx-schedule" class="lgx-schedule">
                            <div class="lgx-inner">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div id="canceledDialog" style="display: none;height: 540px">
                                                <div id="dialog-body" class="remove-session-dialog">
                                                    <div class="text-center ng-star-inserted">
                                                        <p class="error" style="font-size: 14px">@lang('home.Are you sure you want to cancel this time period?')</p>
                                                        @if (auth()->check()&&auth()->user()->type != 'visitors')
                                                            <a target="_blank" href="{{route('page_view',getStaticPageValue(10,'url')) }}">@lang('home.Conditions for canceling the session')</a>
                                                        @endif
                                                        @if ((auth()->check()&&auth()->user()->type == 'visitors')||!auth()->check())
                                                            <a target="_blank" href="{{route('page_view',getStaticPageValue(11,'url')) }}">@lang('home.Conditions for canceling the session')</a>
                                                        @endif
                                                    </div>
                                                    <div class="form-group">
                                                        <lable>@lang('home.Cancel Reason')</lable>
                                                        <textarea name="cancel-reason" id="cancel-reason" class="form-control"></textarea>
                                                        <div id="cancel-reason-error" class="error"></div>
                                                    </div>
                                                    <div>
                                                        <button  class="cancel-btn-session btn btn-danger pull-right pr-5 pl-5" style="font-weight: bold;">@lang('home.yes')</button>
                                                        <button onclick="$('#canceledDialog').dialog('close')" class="btn btn-info pull-left pr-5 pl-5"  style="font-weight: bold;">@lang('home.no')</button>
                                                    </div>
                                                </div>

                                            </div>
                                            <style>
                                                #schedulingDialog .scheduling-session-block > div{
                                                    background: #d180fd;
                                                    border-radius: 10px;
                                                    color: white;
                                                    padding: 5px;
                                                }
                                                #schedulingDialog .scheduling-day{
                                                    font-weight: bold;
                                                }
                                                #schedulingDialog .scheduling-session-block.active img{
                                                    width: 25px;
                                                    position: absolute;
                                                    bottom: 5px;
                                                    display: block;
                                                    left: 15px;
                                                }
                                                #schedulingDialog .scheduling-session-block img{
                                                   display: none;
                                                }
                                            </style>
                                            <div id="schedulingDialog" style="display: none;height: 540px">
                                                <div id="dialog-body" class="scheduling-session-dialog row">
                                                    <img src="{{ asset('img/loading.gif') }}" alt="">
                                                </div>
                                                <div class="errorMessage"></div>
                                                <div class="button-block">

                                                </div>
                                            </div>
                                            <div class="lgx-tab">
                                                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <a class="nav-link" id="pills-previuos-sessions-tab" data-toggle="pill" href="#pills-previuos-sessions" role="tab" aria-controls="pills-previuos-sessions" aria-selected="true">{{trans('home.previuos-sessions')}}</a>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <a class="nav-link active" id="pills-today-sessions-tab" data-toggle="pill" href="#pills-today-sessions" role="tab" aria-controls="pills-today-sessions" aria-selected="false">{{trans('home.today-sessions')}}</a>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <a class="nav-link" id="pills-next-sessions-tab" data-toggle="pill" href="#pills-next-sessions" role="tab" aria-controls="pills-next-sessions" aria-selected="false">{{trans('home.next-sessions')}}</a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content lgx-tab-content" id="pills-tabContent">
                                                    <!-- Previuos Session -->
                                                    <div class="tab-pane fade dir-rtl" id="pills-previuos-sessions" role="tabpanel" aria-labelledby="pills-previuos-sessions-tab">
                                                        <div class="row px-5 py-5 my-2">
                                                            @if(count($previousSessions))
                                                                @include('therapists.include.sessions_blocks',['sessionsBlocks'=>$previousSessions])
                                                            @else
                                                                <div class="text-center col-sm-12">@lang('home.There are no sessions')</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- Today Sessions -->
                                                    <div class="tab-pane fade show active dir-rtl" id="pills-today-sessions" role="tabpanel" aria-labelledby="pills-today-sessions-tab">
                                                        <div class="row px-5 py-5 my-2">
                                                            @if(count($todaySessions))
                                                                @include('therapists.include.sessions_blocks',['sessionsBlocks'=>$todaySessions])
                                                            @else
                                                                <div class="text-center col-sm-12">@lang('home.There are no sessions')</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- Next Sessions -->
                                                    <div class="tab-pane fade dir-rtl" id="pills-next-sessions" role="tabpanel" aria-labelledby="pills-next-sessions-tab">
                                                        <div class="row px-5 py-5 my-2 session-item-block">
                                                            @if(count($nextSessions))
                                                                @include('therapists.include.sessions_blocks',['sessionsBlocks'=>$nextSessions])
                                                            @else
                                                                <div class="text-center col-sm-12">@lang('home.There are no sessions')</div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div> <!-- pills-tabContent -->
                                            </div> <!-- lgx-tab -->
                                        </div>
                                    </div>
                                </div>
                                <!-- //.CONTAINER -->
                            </div>
                            <!-- //.INNER -->
                        </div>
                    </section>
                    <!--SCHEDULE END-->
                </div> <!-- row -->


            </div>
        </div>
    </div>
</div>
@endsection
@section('scriptSection')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.countdown/2.0.3/jquery.countdown.min.js"></script>
    <script src="https://www.jqueryscript.net/demo/Date-Time-Picker-Bootstrap-4/build/js/bootstrap-datetimepicker.min.js"></script>
    <script>
        token= '{{ csrf_token() }}';
        $(document).on('click','#schedulingDialog .scheduling-session-block',function () {
            $("#schedulingDialog .scheduling-session-block").removeClass('active')
            $("#schedulingDialog .scheduling-session-block input[type='radio']").prop('checked',false);
            $(this).addClass('active');
            $(this).find("input[type='radio']").prop('checked',true);

        });

        $(document).on('click','.cancelSession',function(){
            el=$(this);
            cancel_reason=$.trim($("#cancel-reason").val());
            if(!cancel_reason){
                $("#cancel-reason-error").html('ادخل سبب الإلغاء');
                return false
            }
            id=el.attr('data-id');
            el.attr('disabled','disabled');
            $.ajax({
                type: "POST",
                url: "{{ route('visitor_cancel_sessions') }}",
                data: {id,_token:token},
                success: function (msg) {
                    if(msg.success){
                        $('#canceledDialog').dialog('close');
                        $("#cancel-reason").val('')
                        window.location.reload();
                    }else{
                        if(msg.message){
                            $("#cancel-reason-error").html(msg.message);
                        }

                    }
                    el.removeAttr('disabled');
                }
            });
        });
        $(document).on('click','.cancel-session-visitor',function(e){
            e.preventDefault();
            el=$(this)
            id=el.attr('data-id');
            type=el.attr('data-type');
            $("#canceledDialog").dialog({
                title: '@lang('home.Cancel Session')',
                width: ($(window).width() < 500) ? $(window).width() - 20 : 500, // overcomes width:'auto' and maxWidth bug
                maxWidth: 700,
                height: 270,
                modal: true,
                fluid: true, //new option
                resizable: false,
                show: {effect: 'clip', duration: 350},
                hide: {effect: 'clip', duration: 250},
                open: function () {
                    $("#canceledDialog .cancel-btn-session").addClass('cancelSession').attr('data-type',type).attr('data-id',id);
                },
                close:function(){
                    $("#canceledDialog .cancel-btn-session").removeClass('cancelSession').removeAttr('data-type').removeAttr('data-id');
                },
            });


        });
        $(document).on('click','.scheduling-session-visitor',function(e){
            e.preventDefault();
            el=$(this);
            session_id=el.attr('data-id');
            $("#schedulingDialog").dialog({
                title: '@lang('home.Scheduling Session')',
                width: ($(window).width() < 500) ? $(window).width() - 20 : 500, // overcomes width:'auto' and maxWidth bug
                maxWidth: 700,
                height: 270,
                modal: true,
                fluid: true, //new option
                resizable: false,
                show: {effect: 'clip', duration: 350},
                hide: {effect: 'clip', duration: 250},
                open: function () {
                    $.ajax({
                        type: "GET",
                        url: "{{ route('mysessions') }}",
                        data: {session_id,'getSchedulingSessions':true},
                        success: function (msg) {
                            $("#schedulingDialog .scheduling-session-dialog").html(msg.html);
                            if(msg.hasSessions){ 
                                console.log('a1:'+msg.session_id)
                                $("#schedulingDialog .button-block").html('<div class="clearfix p-4">\n' +
                                    '    <button data-id="'+msg.session_id+'" class="scheduling-btn-session btn btn-danger pull-right pr-5 pl-5" style="font-weight: bold;">@lang('home.yes')</button>\n' +
                                    '    <button onclick="$(\'#schedulingDialog\').dialog(\'close\')" class="btn btn-info pull-left pr-5 pl-5"  style="font-weight: bold;">@lang('home.no')</button>\n' +
                                    '</div>');
                            }

                        }
                    });
                },
                close:function(){
                    $("#schedulingDialog .scheduling-session-dialog").html('<img src="{{ asset('img/loading.gif') }}" alt="">')
                },
            });
        })
        $(document).on('click','.scheduling-btn-session',function (e) {
            e.preventDefault();
            el=$(this);
            session_id=el.attr('data-id');
            scheduling_session_id=$("#schedulingSessionForm [name='scheduling_session_id']:checked").val();
            if(scheduling_session_id){
                $("#schedulingDialog .errorMessage").html('');
                el.attr('disabled','disabled');
                $.ajax({
                    type: "POST",
                    url: "{{ route('scheduling_session') }}",
                    data: {session_id,scheduling_session_id,_token:token},
                    success: function (msg) {
                        
                        if(msg.success){
                            
                            $("#schedulingDialog").dialog('close');
                            window.location.reload();
                        }
                        el.removeAttr('disabled');
                    }
                });
            }else{
                $("#schedulingDialog .errorMessage").html('<div class="alert alert-danger">@lang('home.please select session')</div>');
            }

        })
        $('.count-down').each(function(){
            $(this).countdown( $(this).attr('data-date'), function(event) {
                secounds= (parseInt(event.strftime('%D'))*24*60*60)+(parseInt(event.strftime('%H'))*60*60)+(parseInt(event.strftime('%M'))*60)+(parseInt(event.strftime('%S')));

                $(this).text(
                    event.strftime('%D:%H:%M:%S')
                );

                session_id=$(this).attr('data-id');

                if(secounds<=(15*60)){
                    $("#start-btn-"+session_id).removeClass('d-none');
                    $("#session-not-started-"+session_id).hide();
                    $("#scheduling-btn-"+session_id).hide();
                }

                // if(secounds<(8*60*60)){
                //     $("#cancel-btn-btn-"+session_id).addClass('d-none');
                // }

            });
        });
    </script>
@endsection
