@extends('layouts.site')

@section('content')

<section>
    <div class="lgx-banner lgx-banner-inner">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container bartopline">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="lgx-heading-area mt-5">
                                <ul class="breadcrumb">
                                    <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                    <li class="active">{{trans('auth.forget')}}</li>
                                </ul>
                            </div>
                        </div>
                    </div><!--//.ROW-->
                </div><!-- //.CONTAINER -->
            </div><!-- //.INNER -->
        </div>
    </div>
</section>

<div class="lgx-schedule">
    <div class="container-fluid loginstyle">
        <div class="row justify-content-center lgx-inner dynamic-form">

                <div class="col-md-7">
                    <div id="lgx-testimonials"  class="lgx-testimonials">
                        <div class="lgx-inner">
                            <div class="container">
                                <div class="lgx-content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="lgx-testiowlarea">
                                                <div id="lgx-owltestimonial" class="owl-carousel lgx-owltestimonial">
                                                    @foreach ($services as $item)
                                                    <div class="item lgx-fadeInLeft">
                                                        <figure class="lgx-client-image">
                                                            <figcaption class="lgx-zoomIn-q">
                                                                <i class="fa fa-quote-left"></i>
                                                            </figcaption>
                                                        </figure>
                                                        <div class="testi-info-area">
                                                            <p class="lgx-review">
                                                                {{config('app.locale') == "ar" ? $item->title_ar : $item->title_en}}
                                                            </p>
                                                        </div>
                                                    </div> <!--//.Item-->
                                                    @endforeach
                                                </div><!--l//#LGX-OWL TESTIMONIAL-->
                                            </div>
                                        </div> <!--//.COL 12 -->
                                    </div> <!--//.ROW-->
                                </div> <!--//.LGX CONTENT-->
                            </div> <!--//.CONTAINER-->
                        </div><!--//.LGX INNER-->
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="lgx-tab">
                        <div class="align-items-center pt-3 mt-5 boxing">
                                @if (session('status'))
                                    <p class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('status') ? 'تم الارسال بنجاح': 'فشل الارسال' }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                @endif

                                <form method="POST" action="{{ route('send-email-verification') }}" class="col align-self-center" data-parsley-validate="" >
                                @csrf

                                <div class="form-group">
                                    <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}"  autocomplete="email" autofocus placeholder="{{trans('auth.email')}}"
                                    data-parsley-maxlength="30"
                                    data-parsley-required="true"
                                    data-parsley-required-message="عذرا .. ليس لديك حساب"
                                    >

                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12">
                                        <button type="submit" class="lgx-btn mt-3" style="width: 100%">
                                            {{ trans('auth.re-send') }}
                                        </button>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 mb-5">
                                       <a href="{{route('login')}}">{{ trans('auth.login') }}</a>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>


        </div>
    </div>
</div>
@endsection
