@extends('layouts.site')

@section('content')
    <section>
        <div class="lgx-banner lgx-banner-inner">
            <div class="lgx-inner-bg " >
                <div class="lgx-inner">
                    <div class="container bartopline">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="lgx-heading-area mt-5">
                                    <ul class="breadcrumb">
                                        <li><a href="{{ route('index') }}"><i class="icon-home6"></i>{{trans('home.home')}}</a></li>
                                        <li class="active"> {{trans('auth.password-reset')}} </li>
                                    </ul>
                                </div>
                            </div>
                        </div><!--//.ROW-->
                    </div><!-- //.CONTAINER -->
                </div><!-- //.INNER -->
            </div>
        </div>
    </section>

    <div class="lgx-schedule ">
        <div class="container-fluid loginstyle">
            <div class="row justify-content-center lgx-inner">
                @if(isset($testimonial))
                <div class="col-md-7">
                    <div id="lgx-testimonials"  class="lgx-testimonials ">
                        <div class="lgx-inner">
                            <div class="container">
                                <div class="lgx-content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="lgx-testiowlarea">
                                                <div id="lgx-owltestimonial" class="owl-carousel lgx-owltestimonial">
                                                    @foreach ($testimonial as $item)
                                                        <div class="item lgx-fadeInLeft">
                                                            <figure class="lgx-client-image">
                                                                <figcaption class="lgx-zoomIn-q">
                                                                    <i class="fa fa-quote-left"></i>
                                                                </figcaption>
                                                            </figure>
                                                            <div class="testi-info-area">
                                                                <p class="lgx-review">
                                                                    {{$item->comment}}
                                                                </p>
                                                                <h4 class="lgx-client-name">{{($item->visitor)?$item->visitor->name:''}}</h4>
                                                            </div>
                                                        </div> <!--//.Item-->
                                                    @endforeach
                                                </div><!--l//#LGX-OWL TESTIMONIAL-->
                                            </div>
                                        </div> <!--//.COL 12 -->
                                    </div> <!--//.ROW-->
                                </div> <!--//.LGX CONTENT-->
                            </div> <!--//.CONTAINER-->
                        </div><!--//.LGX INNER-->
                    </div>
                </div>
                @endif
                <div class="col-md-5">
                    <div class="lgx-tab">
                        <div class="align-items-center p-md-5 p-3 boxing">

                            <form method="POST" action="{{ url('/update_user_password') }}" class="col align-self-center" data-parsley-validate="">
                                @csrf
                                <input type="hidden" name="token" value="{{ $token }}">
                                <div class="form-group">
                                    <input id="email" type="email" class="forminput form-control @error('email') is-invalid @enderror" name="email" value="{{ $email }}"   autocomplete="email" placeholder="{{trans('auth.email')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                           tabindex="1"
                                    >
                                    @error('email')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <input id="password" type="password" class="forminput form-control @error('password') is-invalid @enderror" name="password"  autocomplete="new-password" placeholder="{{trans('auth.password')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                           tabindex="2"
                                    >
                                    @error('password')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                    @enderror
                                </div>

                                <div class="form-group">

                                    <input id="password-confirm" type="password" class="forminput form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation"  autocomplete="new-password" placeholder="{{trans('auth.passwordconfirm')}}"
                                           data-parsley-required="true"
                                           data-parsley-required-message=" هذا الحقل الزامى"
                                           tabindex="3"
                                    >
                                    @error('password_confirmation')
                                    <p class="alert alert-danger alert-dismissible fade show" role="alert">{{ $message }}
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </p>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <div class="col-md-12 px-0">
                                        <button type="submit" class="lgx-btn" style="width: 100%">
                                            {{ trans('auth.update-password') }}
                                        </button>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
